/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.x9.X9IntegerConverter;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;

public class X9FieldElement
extends ASN1Object {
    protected ECFieldElement f;
    private static X9IntegerConverter a = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement f2) {
        this.f = f2;
    }

    public X9FieldElement(BigInteger p2, ASN1OctetString s2) {
        this(new ECFieldElement.Fp(p2, new BigInteger(1, s2.getOctets())));
    }

    public X9FieldElement(int m2, int k1, int k2, int k3, ASN1OctetString s2) {
        this(new ECFieldElement.F2m(m2, k1, k2, k3, new BigInteger(1, s2.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        int n2 = a.getByteLength(this.f);
        byte[] byArray = a.integerToBytes(this.f.toBigInteger(), n2);
        return new DEROctetString(byArray);
    }
}

