/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import java.math.BigInteger;

public class X9FieldID
extends ASN1Object
implements X9ObjectIdentifiers {
    private ASN1ObjectIdentifier a;
    private ASN1Primitive b;

    public X9FieldID(BigInteger primeP) {
        this.a = prime_field;
        this.b = new ASN1Integer(primeP);
    }

    public X9FieldID(int m2, int k1) {
        this(m2, k1, 0, 0);
    }

    public X9FieldID(int m2, int k1, int k2, int k3) {
        this.a = characteristic_two_field;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(m2));
        if (k2 == 0) {
            if (k3 != 0) {
                throw new IllegalArgumentException("inconsistent k values");
            }
            aSN1EncodableVector.add(tpBasis);
            aSN1EncodableVector.add(new ASN1Integer(k1));
        } else {
            if (k2 <= k1 || k3 <= k2) {
                throw new IllegalArgumentException("inconsistent k values");
            }
            aSN1EncodableVector.add(ppBasis);
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(new ASN1Integer(k1));
            aSN1EncodableVector2.add(new ASN1Integer(k2));
            aSN1EncodableVector2.add(new ASN1Integer(k3));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        this.b = new DERSequence(aSN1EncodableVector);
    }

    private X9FieldID(ASN1Sequence seq) {
        this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        this.b = seq.getObjectAt(1).toASN1Primitive();
    }

    public static X9FieldID getInstance(Object obj) {
        if (obj instanceof X9FieldID) {
            return (X9FieldID)obj;
        }
        if (obj != null) {
            return new X9FieldID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1ObjectIdentifier getIdentifier() {
        return this.a;
    }

    public ASN1Primitive getParameters() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

