/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;

public abstract class StreamBlockCipher
implements BlockCipher,
StreamCipher {
    private final BlockCipher a;

    protected StreamBlockCipher(BlockCipher cipher) {
        this.a = cipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public final byte returnByte(byte in) {
        return this.calculateByte(in);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too small");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n2 = inOff;
        int n3 = inOff + len;
        int n4 = outOff;
        while (n2 < n3) {
            out[n4++] = this.calculateByte(in[n2++]);
        }
        return len;
    }

    protected abstract byte calculateByte(byte var1);
}

