/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.jpake;

import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKERound1Payload;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKERound2Payload;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKERound3Payload;
import com.enterprisedt.bouncycastle.crypto.agreement.jpake.JPAKEUtil;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public class JPAKEParticipant {
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_ROUND_1_CREATED = 10;
    public static final int STATE_ROUND_1_VALIDATED = 20;
    public static final int STATE_ROUND_2_CREATED = 30;
    public static final int STATE_ROUND_2_VALIDATED = 40;
    public static final int STATE_KEY_CALCULATED = 50;
    public static final int STATE_ROUND_3_CREATED = 60;
    public static final int STATE_ROUND_3_VALIDATED = 70;
    private final String a;
    private char[] b;
    private final Digest c;
    private final SecureRandom d;
    private final BigInteger e;
    private final BigInteger f;
    private final BigInteger g;
    private String h;
    private BigInteger i;
    private BigInteger j;
    private BigInteger k;
    private BigInteger l;
    private BigInteger m;
    private BigInteger n;
    private BigInteger o;
    private int p;

    public JPAKEParticipant(String participantId, char[] password) {
        this(participantId, password, JPAKEPrimeOrderGroups.NIST_3072);
    }

    public JPAKEParticipant(String participantId, char[] password, JPAKEPrimeOrderGroup group) {
        this(participantId, password, group, new SHA256Digest(), CryptoServicesRegistrar.getSecureRandom());
    }

    public JPAKEParticipant(String participantId, char[] password, JPAKEPrimeOrderGroup group, Digest digest, SecureRandom random) {
        JPAKEUtil.validateNotNull(participantId, "participantId");
        JPAKEUtil.validateNotNull(password, "password");
        JPAKEUtil.validateNotNull(group, "p");
        JPAKEUtil.validateNotNull(digest, "digest");
        JPAKEUtil.validateNotNull(random, "random");
        if (password.length == 0) {
            throw new IllegalArgumentException("Password must not be empty.");
        }
        this.a = participantId;
        this.b = Arrays.copyOf(password, password.length);
        this.e = group.getP();
        this.f = group.getQ();
        this.g = group.getG();
        this.c = digest;
        this.d = random;
        this.p = 0;
    }

    public int getState() {
        return this.p;
    }

    public JPAKERound1Payload createRound1PayloadToSend() {
        if (this.p >= 10) {
            throw new IllegalStateException("Round1 payload already created for " + this.a);
        }
        this.i = JPAKEUtil.generateX1(this.f, this.d);
        this.j = JPAKEUtil.generateX2(this.f, this.d);
        this.k = JPAKEUtil.calculateGx(this.e, this.g, this.i);
        this.l = JPAKEUtil.calculateGx(this.e, this.g, this.j);
        BigInteger[] bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof(this.e, this.f, this.g, this.k, this.i, this.a, this.c, this.d);
        BigInteger[] bigIntegerArray2 = JPAKEUtil.calculateZeroKnowledgeProof(this.e, this.f, this.g, this.l, this.j, this.a, this.c, this.d);
        this.p = 10;
        return new JPAKERound1Payload(this.a, this.k, this.l, bigIntegerArray, bigIntegerArray2);
    }

    public void validateRound1PayloadReceived(JPAKERound1Payload round1PayloadReceived) throws CryptoException {
        if (this.p >= 20) {
            throw new IllegalStateException("Validation already attempted for round1 payload for" + this.a);
        }
        this.h = round1PayloadReceived.getParticipantId();
        this.m = round1PayloadReceived.getGx1();
        this.n = round1PayloadReceived.getGx2();
        BigInteger[] bigIntegerArray = round1PayloadReceived.getKnowledgeProofForX1();
        BigInteger[] bigIntegerArray2 = round1PayloadReceived.getKnowledgeProofForX2();
        JPAKEUtil.validateParticipantIdsDiffer(this.a, round1PayloadReceived.getParticipantId());
        JPAKEUtil.validateGx4(this.n);
        JPAKEUtil.validateZeroKnowledgeProof(this.e, this.f, this.g, this.m, bigIntegerArray, round1PayloadReceived.getParticipantId(), this.c);
        JPAKEUtil.validateZeroKnowledgeProof(this.e, this.f, this.g, this.n, bigIntegerArray2, round1PayloadReceived.getParticipantId(), this.c);
        this.p = 20;
    }

    public JPAKERound2Payload createRound2PayloadToSend() {
        if (this.p >= 30) {
            throw new IllegalStateException("Round2 payload already created for " + this.a);
        }
        if (this.p < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to creating Round2 payload for " + this.a);
        }
        BigInteger bigInteger = JPAKEUtil.calculateGA(this.e, this.k, this.m, this.n);
        BigInteger bigInteger2 = JPAKEUtil.calculateS(this.b);
        BigInteger bigInteger3 = JPAKEUtil.calculateX2s(this.f, this.j, bigInteger2);
        BigInteger bigInteger4 = JPAKEUtil.calculateA(this.e, this.f, bigInteger, bigInteger3);
        BigInteger[] bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof(this.e, this.f, bigInteger, bigInteger4, bigInteger3, this.a, this.c, this.d);
        this.p = 30;
        return new JPAKERound2Payload(this.a, bigInteger4, bigIntegerArray);
    }

    public void validateRound2PayloadReceived(JPAKERound2Payload round2PayloadReceived) throws CryptoException {
        if (this.p >= 40) {
            throw new IllegalStateException("Validation already attempted for round2 payload for" + this.a);
        }
        if (this.p < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to validating Round2 payload for " + this.a);
        }
        BigInteger bigInteger = JPAKEUtil.calculateGA(this.e, this.m, this.k, this.l);
        this.o = round2PayloadReceived.getA();
        BigInteger[] bigIntegerArray = round2PayloadReceived.getKnowledgeProofForX2s();
        JPAKEUtil.validateParticipantIdsDiffer(this.a, round2PayloadReceived.getParticipantId());
        JPAKEUtil.validateParticipantIdsEqual(this.h, round2PayloadReceived.getParticipantId());
        JPAKEUtil.validateGa(bigInteger);
        JPAKEUtil.validateZeroKnowledgeProof(this.e, this.f, bigInteger, this.o, bigIntegerArray, round2PayloadReceived.getParticipantId(), this.c);
        this.p = 40;
    }

    public BigInteger calculateKeyingMaterial() {
        if (this.p >= 50) {
            throw new IllegalStateException("Key already calculated for " + this.a);
        }
        if (this.p < 40) {
            throw new IllegalStateException("Round2 payload must be validated prior to creating key for " + this.a);
        }
        BigInteger bigInteger = JPAKEUtil.calculateS(this.b);
        Arrays.fill(this.b, '\u0000');
        this.b = null;
        BigInteger bigInteger2 = JPAKEUtil.calculateKeyingMaterial(this.e, this.f, this.n, this.j, bigInteger, this.o);
        this.i = null;
        this.j = null;
        this.o = null;
        this.p = 50;
        return bigInteger2;
    }

    public JPAKERound3Payload createRound3PayloadToSend(BigInteger keyingMaterial) {
        if (this.p >= 60) {
            throw new IllegalStateException("Round3 payload already created for " + this.a);
        }
        if (this.p < 50) {
            throw new IllegalStateException("Keying material must be calculated prior to creating Round3 payload for " + this.a);
        }
        BigInteger bigInteger = JPAKEUtil.calculateMacTag(this.a, this.h, this.k, this.l, this.m, this.n, keyingMaterial, this.c);
        this.p = 60;
        return new JPAKERound3Payload(this.a, bigInteger);
    }

    public void validateRound3PayloadReceived(JPAKERound3Payload round3PayloadReceived, BigInteger keyingMaterial) throws CryptoException {
        if (this.p >= 70) {
            throw new IllegalStateException("Validation already attempted for round3 payload for" + this.a);
        }
        if (this.p < 50) {
            throw new IllegalStateException("Keying material must be calculated validated prior to validating Round3 payload for " + this.a);
        }
        JPAKEUtil.validateParticipantIdsDiffer(this.a, round3PayloadReceived.getParticipantId());
        JPAKEUtil.validateParticipantIdsEqual(this.h, round3PayloadReceived.getParticipantId());
        JPAKEUtil.validateMacTag(this.a, this.h, this.k, this.l, this.m, this.n, keyingMaterial, this.c, round3PayloadReceived.getMacTag());
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        this.p = 70;
    }
}

