/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.kdf;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;

public class ConcatenationKDFGenerator
implements DerivationFunction {
    private Digest a;
    private byte[] b;
    private byte[] c;
    private int d;

    public ConcatenationKDFGenerator(Digest digest) {
        this.a = digest;
        this.d = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters param) {
        if (!(param instanceof KDFParameters)) {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
        KDFParameters kDFParameters = (KDFParameters)param;
        this.b = kDFParameters.getSharedSecret();
        this.c = kDFParameters.getIV();
    }

    public Digest getDigest() {
        return this.a;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        byte[] byArray = new byte[this.d];
        byte[] byArray2 = new byte[4];
        int n2 = 1;
        int n3 = 0;
        this.a.reset();
        if (len > this.d) {
            do {
                this.a(n2, byArray2);
                this.a.update(byArray2, 0, byArray2.length);
                this.a.update(this.b, 0, this.b.length);
                this.a.update(this.c, 0, this.c.length);
                this.a.doFinal(byArray, 0);
                System.arraycopy(byArray, 0, out, outOff + n3, this.d);
                n3 += this.d;
            } while (n2++ < len / this.d);
        }
        if (n3 < len) {
            this.a(n2, byArray2);
            this.a.update(byArray2, 0, byArray2.length);
            this.a.update(this.b, 0, this.b.length);
            this.a.update(this.c, 0, this.c.length);
            this.a.doFinal(byArray, 0);
            System.arraycopy(byArray, 0, out, outOff + n3, len - n3);
        }
        return len;
    }
}

