/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement.kdf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public class DHKEKGenerator
implements DerivationFunction {
    private final Digest a;
    private ASN1ObjectIdentifier b;
    private int c;
    private byte[] d;
    private byte[] e;

    public DHKEKGenerator(Digest digest) {
        this.a = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)param;
        this.b = dHKDFParameters.getAlgorithm();
        this.c = dHKDFParameters.getKeySize();
        this.d = dHKDFParameters.getZ();
        this.e = dHKDFParameters.getExtraInfo();
    }

    public Digest getDigest() {
        return this.a;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        long l2 = len;
        int n2 = this.a.getDigestSize();
        if (l2 > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int n3 = (int)((l2 + (long)n2 - 1L) / (long)n2);
        byte[] byArray = new byte[this.a.getDigestSize()];
        int n4 = 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a.update(this.d, 0, this.d.length);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(this.b);
            aSN1EncodableVector2.add(new DEROctetString(Pack.intToBigEndian(n4)));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
            if (this.e != null) {
                aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DEROctetString(this.e)));
            }
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.c))));
            try {
                byte[] byArray2 = new DERSequence(aSN1EncodableVector).getEncoded("DER");
                this.a.update(byArray2, 0, byArray2.length);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to encode parameter info: " + iOException.getMessage());
            }
            this.a.doFinal(byArray, 0);
            if (len > n2) {
                System.arraycopy(byArray, 0, out, outOff, n2);
                outOff += n2;
                len -= n2;
            } else {
                System.arraycopy(byArray, 0, out, outOff, len);
            }
            ++n4;
        }
        this.a.reset();
        return (int)l2;
    }
}

