/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] a = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};
    private static int c = 12;
    private int d = 64;
    private int e = 0;
    private byte[] f = null;
    private byte[] g = null;
    private byte[] h = null;
    private byte[] i = null;
    private int j = 0;
    private long[] k = new long[16];
    private long[] l = null;
    private long m = 0L;
    private long n = 0L;
    private long o = 0L;

    public Blake2bDigest() {
        this(512);
    }

    public Blake2bDigest(Blake2bDigest digest) {
        this.j = digest.j;
        this.i = Arrays.clone(digest.i);
        this.e = digest.e;
        this.h = Arrays.clone(digest.h);
        this.d = digest.d;
        this.l = Arrays.clone(digest.l);
        this.g = Arrays.clone(digest.g);
        this.f = Arrays.clone(digest.f);
        this.m = digest.m;
        this.n = digest.n;
        this.o = digest.o;
    }

    public Blake2bDigest(int digestSize) {
        if (digestSize < 8 || digestSize > 512 || digestSize % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2b digest bit length must be a multiple of 8 and not greater than 512");
        }
        this.i = new byte[128];
        this.e = 0;
        this.d = digestSize / 8;
        this.a();
    }

    public Blake2bDigest(byte[] key) {
        this.i = new byte[128];
        if (key != null) {
            this.h = new byte[key.length];
            System.arraycopy(key, 0, this.h, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.e = key.length;
            System.arraycopy(key, 0, this.i, 0, key.length);
            this.j = 128;
        }
        this.d = 64;
        this.a();
    }

    public Blake2bDigest(byte[] key, int digestLength, byte[] salt, byte[] personalization) {
        this.i = new byte[128];
        if (digestLength < 1 || digestLength > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.d = digestLength;
        if (salt != null) {
            if (salt.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.f = new byte[16];
            System.arraycopy(salt, 0, this.f, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.g = new byte[16];
            System.arraycopy(personalization, 0, this.g, 0, personalization.length);
        }
        if (key != null) {
            this.h = new byte[key.length];
            System.arraycopy(key, 0, this.h, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.e = key.length;
            System.arraycopy(key, 0, this.i, 0, key.length);
            this.j = 128;
        }
        this.a();
    }

    private void a() {
        if (this.l == null) {
            this.l = new long[8];
            this.l[0] = a[0] ^ (long)(this.d | this.e << 8 | 0x1010000);
            this.l[1] = a[1];
            this.l[2] = a[2];
            this.l[3] = a[3];
            this.l[4] = a[4];
            this.l[5] = a[5];
            if (this.f != null) {
                this.l[4] = this.l[4] ^ Pack.littleEndianToLong(this.f, 0);
                this.l[5] = this.l[5] ^ Pack.littleEndianToLong(this.f, 8);
            }
            this.l[6] = a[6];
            this.l[7] = a[7];
            if (this.g != null) {
                this.l[6] = this.l[6] ^ Pack.littleEndianToLong(this.g, 0);
                this.l[7] = this.l[7] ^ Pack.littleEndianToLong(this.g, 8);
            }
        }
    }

    private void b() {
        System.arraycopy(this.l, 0, this.k, 0, this.l.length);
        System.arraycopy(a, 0, this.k, this.l.length, 4);
        this.k[12] = this.m ^ a[4];
        this.k[13] = this.n ^ a[5];
        this.k[14] = this.o ^ a[6];
        this.k[15] = a[7];
    }

    @Override
    public void update(byte b2) {
        int n2 = 0;
        n2 = 128 - this.j;
        if (n2 == 0) {
            this.m += 128L;
            if (this.m == 0L) {
                ++this.n;
            }
        } else {
            this.i[this.j] = b2;
            ++this.j;
            return;
        }
        this.a(this.i, 0);
        Arrays.fill(this.i, (byte)0);
        this.i[0] = b2;
        this.j = 1;
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        if (message == null || len == 0) {
            return;
        }
        int n3 = 0;
        if (this.j != 0) {
            n3 = 128 - this.j;
            if (n3 < len) {
                System.arraycopy(message, offset, this.i, this.j, n3);
                this.m += 128L;
                if (this.m == 0L) {
                    ++this.n;
                }
                this.a(this.i, 0);
                this.j = 0;
                Arrays.fill(this.i, (byte)0);
            } else {
                System.arraycopy(message, offset, this.i, this.j, len);
                this.j += len;
                return;
            }
        }
        int n4 = offset + len - 128;
        for (n2 = offset + n3; n2 < n4; n2 += 128) {
            this.m += 128L;
            if (this.m == 0L) {
                ++this.n;
            }
            this.a(message, n2);
        }
        System.arraycopy(message, n2, this.i, 0, offset + len - n2);
        this.j += offset + len - n2;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        this.o = -1L;
        this.m += (long)this.j;
        if (this.j > 0 && this.m == 0L) {
            ++this.n;
        }
        this.a(this.i, 0);
        Arrays.fill(this.i, (byte)0);
        Arrays.fill(this.k, 0L);
        for (int i2 = 0; i2 < this.l.length && i2 * 8 < this.d; ++i2) {
            byte[] byArray = Pack.longToLittleEndian(this.l[i2]);
            if (i2 * 8 < this.d - 8) {
                System.arraycopy(byArray, 0, out, outOffset + i2 * 8, 8);
                continue;
            }
            System.arraycopy(byArray, 0, out, outOffset + i2 * 8, this.d - i2 * 8);
        }
        Arrays.fill(this.l, 0L);
        this.reset();
        return this.d;
    }

    @Override
    public void reset() {
        this.j = 0;
        this.o = 0L;
        this.m = 0L;
        this.n = 0L;
        this.l = null;
        Arrays.fill(this.i, (byte)0);
        if (this.h != null) {
            System.arraycopy(this.h, 0, this.i, 0, this.h.length);
            this.j = 128;
        }
        this.a();
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.b();
        long[] lArray = new long[16];
        for (n3 = 0; n3 < 16; ++n3) {
            lArray[n3] = Pack.littleEndianToLong(byArray, n2 + n3 * 8);
        }
        for (n3 = 0; n3 < c; ++n3) {
            this.a(lArray[b[n3][0]], lArray[b[n3][1]], 0, 4, 8, 12);
            this.a(lArray[b[n3][2]], lArray[b[n3][3]], 1, 5, 9, 13);
            this.a(lArray[b[n3][4]], lArray[b[n3][5]], 2, 6, 10, 14);
            this.a(lArray[b[n3][6]], lArray[b[n3][7]], 3, 7, 11, 15);
            this.a(lArray[b[n3][8]], lArray[b[n3][9]], 0, 5, 10, 15);
            this.a(lArray[b[n3][10]], lArray[b[n3][11]], 1, 6, 11, 12);
            this.a(lArray[b[n3][12]], lArray[b[n3][13]], 2, 7, 8, 13);
            this.a(lArray[b[n3][14]], lArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.l.length; ++n3) {
            this.l[n3] = this.l[n3] ^ this.k[n3] ^ this.k[n3 + 8];
        }
    }

    private void a(long l2, long l3, int n2, int n3, int n4, int n5) {
        this.k[n2] = this.k[n2] + this.k[n3] + l2;
        this.k[n5] = Blake2bDigest.a(this.k[n5] ^ this.k[n2], 32);
        this.k[n4] = this.k[n4] + this.k[n5];
        this.k[n3] = Blake2bDigest.a(this.k[n3] ^ this.k[n4], 24);
        this.k[n2] = this.k[n2] + this.k[n3] + l3;
        this.k[n5] = Blake2bDigest.a(this.k[n5] ^ this.k[n2], 16);
        this.k[n4] = this.k[n4] + this.k[n5];
        this.k[n3] = Blake2bDigest.a(this.k[n3] ^ this.k[n4], 63);
    }

    private static long a(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2b";
    }

    @Override
    public int getDigestSize() {
        return this.d;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (this.h != null) {
            Arrays.fill(this.h, (byte)0);
            Arrays.fill(this.i, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.f != null) {
            Arrays.fill(this.f, (byte)0);
        }
    }
}

