/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.DESEngine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] a = null;
    private int[] b = null;
    private int[] c = null;
    private boolean d;

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + params.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)params).getKey();
        if (byArray.length != 24 && byArray.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.d = encrypting;
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        this.a = this.generateWorkingKey(encrypting, byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
        this.b = this.generateWorkingKey(!encrypting, byArray3);
        if (byArray.length == 24) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 16, byArray4, 0, byArray4.length);
            this.c = this.generateWorkingKey(encrypting, byArray4);
        } else {
            this.c = this.a;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.a == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray = new byte[8];
        if (this.d) {
            this.desFunc(this.a, in, inOff, byArray, 0);
            this.desFunc(this.b, byArray, 0, byArray, 0);
            this.desFunc(this.c, byArray, 0, out, outOff);
        } else {
            this.desFunc(this.c, in, inOff, byArray, 0);
            this.desFunc(this.b, byArray, 0, byArray, 0);
            this.desFunc(this.a, byArray, 0, out, outOff);
        }
        return 8;
    }

    @Override
    public void reset() {
    }
}

