/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.DESedeEngine;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.util.DigestFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DESedeWrapEngine
implements Wrapper {
    private CBCBlockCipher c;
    private KeyParameter d;
    private ParametersWithIV e;
    private byte[] f;
    private boolean g;
    private static final byte[] h = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest a = DigestFactory.createSHA1();
    byte[] b = new byte[20];

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        SecureRandom secureRandom;
        this.g = forWrapping;
        this.c = new CBCBlockCipher(new DESedeEngine());
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            param = parametersWithRandom.getParameters();
            secureRandom = parametersWithRandom.getRandom();
        } else {
            secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        if (param instanceof KeyParameter) {
            this.d = (KeyParameter)param;
            if (this.g) {
                this.f = new byte[8];
                secureRandom.nextBytes(this.f);
                this.e = new ParametersWithIV(this.d, this.f);
            }
        } else if (param instanceof ParametersWithIV) {
            this.e = (ParametersWithIV)param;
            this.f = this.e.getIV();
            this.d = (KeyParameter)this.e.getParameters();
            if (this.g) {
                if (this.f == null || this.f.length != 8) {
                    throw new IllegalArgumentException("IV is not 8 octets");
                }
            } else {
                throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.g) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        byte[] byArray = new byte[inLen];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        byte[] byArray2 = this.a(byArray);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        int n2 = this.c.getBlockSize();
        if (byArray3.length % n2 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.c.init(true, this.e);
        byte[] byArray4 = new byte[byArray3.length];
        for (int i2 = 0; i2 != byArray3.length; i2 += n2) {
            this.c.processBlock(byArray3, i2, byArray4, i2);
        }
        byte[] byArray5 = new byte[this.f.length + byArray4.length];
        System.arraycopy(this.f, 0, byArray5, 0, this.f.length);
        System.arraycopy(byArray4, 0, byArray5, this.f.length, byArray4.length);
        byte[] byArray6 = DESedeWrapEngine.b(byArray5);
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.d, h);
        this.c.init(true, parametersWithIV);
        for (int i3 = 0; i3 != byArray6.length; i3 += n2) {
            this.c.processBlock(byArray6, i3, byArray6, i3);
        }
        return byArray6;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.g) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (in == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        int n2 = this.c.getBlockSize();
        if (inLen % n2 != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + n2);
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.d, h);
        this.c.init(false, parametersWithIV);
        byte[] byArray = new byte[inLen];
        for (int i2 = 0; i2 != inLen; i2 += n2) {
            this.c.processBlock(in, inOff + i2, byArray, i2);
        }
        byte[] byArray2 = DESedeWrapEngine.b(byArray);
        this.f = new byte[8];
        byte[] byArray3 = new byte[byArray2.length - 8];
        System.arraycopy(byArray2, 0, this.f, 0, 8);
        System.arraycopy(byArray2, 8, byArray3, 0, byArray2.length - 8);
        this.e = new ParametersWithIV(this.d, this.f);
        this.c.init(false, this.e);
        byte[] byArray4 = new byte[byArray3.length];
        for (int i3 = 0; i3 != byArray4.length; i3 += n2) {
            this.c.processBlock(byArray3, i3, byArray4, i3);
        }
        byte[] byArray5 = new byte[byArray4.length - 8];
        byte[] byArray6 = new byte[8];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length - 8);
        System.arraycopy(byArray4, byArray4.length - 8, byArray6, 0, 8);
        if (!this.a(byArray5, byArray6)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        return byArray5;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.a.update(byArray, 0, byArray.length);
        this.a.doFinal(this.b, 0);
        System.arraycopy(this.b, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.a(byArray), byArray2);
    }

    private static byte[] b(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - (i2 + 1)];
        }
        return byArray2;
    }
}

