/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.params.ElGamalKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private ElGamalKeyParameters a;
    private SecureRandom b;
    private boolean c;
    private int d;
    private static final BigInteger e = BigInteger.valueOf(0L);
    private static final BigInteger f = BigInteger.valueOf(1L);
    private static final BigInteger g = BigInteger.valueOf(2L);

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        Object object;
        if (param instanceof ParametersWithRandom) {
            object = (ParametersWithRandom)param;
            this.a = (ElGamalKeyParameters)((ParametersWithRandom)object).getParameters();
            this.b = ((ParametersWithRandom)object).getRandom();
        } else {
            this.a = (ElGamalKeyParameters)param;
            this.b = CryptoServicesRegistrar.getSecureRandom();
        }
        this.c = forEncryption;
        object = this.a.getParameters().getP();
        this.d = ((BigInteger)object).bitLength();
        if (forEncryption) {
            if (!(this.a instanceof ElGamalPublicKeyParameters)) {
                throw new IllegalArgumentException("ElGamalPublicKeyParameters are required for encryption.");
            }
        } else if (!(this.a instanceof ElGamalPrivateKeyParameters)) {
            throw new IllegalArgumentException("ElGamalPrivateKeyParameters are required for decryption.");
        }
    }

    @Override
    public int getInputBlockSize() {
        if (this.c) {
            return (this.d - 1) / 8;
        }
        return 2 * ((this.d + 7) / 8);
    }

    @Override
    public int getOutputBlockSize() {
        if (this.c) {
            return 2 * ((this.d + 7) / 8);
        }
        return (this.d - 1) / 8;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        byte[] byArray;
        int n2;
        if (this.a == null) {
            throw new IllegalStateException("ElGamal engine not initialised");
        }
        int n3 = n2 = this.c ? (this.d - 1 + 7) / 8 : this.getInputBlockSize();
        if (inLen > n2) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        BigInteger bigInteger = this.a.getParameters().getP();
        if (this.a instanceof ElGamalPrivateKeyParameters) {
            byte[] byArray2 = new byte[inLen / 2];
            byte[] byArray3 = new byte[inLen / 2];
            System.arraycopy(in, inOff, byArray2, 0, byArray2.length);
            System.arraycopy(in, inOff + byArray2.length, byArray3, 0, byArray3.length);
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            BigInteger bigInteger3 = new BigInteger(1, byArray3);
            ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)this.a;
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger.subtract(f).subtract(elGamalPrivateKeyParameters.getX()), bigInteger).multiply(bigInteger3).mod(bigInteger);
            return BigIntegers.asUnsignedByteArray(bigInteger4);
        }
        if (inOff != 0 || inLen != in.length) {
            byArray = new byte[inLen];
            System.arraycopy(in, inOff, byArray, 0, inLen);
        } else {
            byArray = in;
        }
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        if (bigInteger5.compareTo(bigInteger) >= 0) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)this.a;
        int n4 = bigInteger.bitLength();
        BigInteger bigInteger6 = new BigInteger(n4, this.b);
        while (bigInteger6.equals(e) || bigInteger6.compareTo(bigInteger.subtract(g)) > 0) {
            bigInteger6 = new BigInteger(n4, this.b);
        }
        BigInteger bigInteger7 = this.a.getParameters().getG();
        BigInteger bigInteger8 = bigInteger7.modPow(bigInteger6, bigInteger);
        BigInteger bigInteger9 = bigInteger5.multiply(elGamalPublicKeyParameters.getY().modPow(bigInteger6, bigInteger)).mod(bigInteger);
        byte[] byArray4 = bigInteger8.toByteArray();
        byte[] byArray5 = bigInteger9.toByteArray();
        byte[] byArray6 = new byte[this.getOutputBlockSize()];
        if (byArray4.length > byArray6.length / 2) {
            System.arraycopy(byArray4, 1, byArray6, byArray6.length / 2 - (byArray4.length - 1), byArray4.length - 1);
        } else {
            System.arraycopy(byArray4, 0, byArray6, byArray6.length / 2 - byArray4.length, byArray4.length);
        }
        if (byArray5.length > byArray6.length / 2) {
            System.arraycopy(byArray5, 1, byArray6, byArray6.length - (byArray5.length - 1), byArray5.length - 1);
        } else {
            System.arraycopy(byArray5, 0, byArray6, byArray6.length - byArray5.length, byArray5.length);
        }
        return byArray6;
    }
}

