/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class ISAACEngine
implements StreamCipher {
    private final int a = 8;
    private final int b = 256;
    private int[] c = null;
    private int[] d = null;
    private int e = 0;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private byte[] i = new byte[1024];
    private byte[] j = null;
    private boolean k = false;

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to ISAAC init - " + params.getClass().getName());
        }
        KeyParameter keyParameter = (KeyParameter)params;
        this.a(keyParameter.getKey());
    }

    @Override
    public byte returnByte(byte in) {
        if (this.h == 0) {
            this.a();
            this.i = Pack.intToBigEndian(this.d);
        }
        byte by = (byte)(this.i[this.h] ^ in);
        this.h = this.h + 1 & 0x3FF;
        return by;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (!this.k) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.h == 0) {
                this.a();
                this.i = Pack.intToBigEndian(this.d);
            }
            out[i2 + outOff] = (byte)(this.i[this.h] ^ in[i2 + inOff]);
            this.h = this.h + 1 & 0x3FF;
        }
        return len;
    }

    @Override
    public String getAlgorithmName() {
        return "ISAAC";
    }

    @Override
    public void reset() {
        this.a(this.j);
    }

    private void a(byte[] byArray) {
        int n2;
        this.j = byArray;
        if (this.c == null) {
            this.c = new int[256];
        }
        if (this.d == null) {
            this.d = new int[256];
        }
        for (n2 = 0; n2 < 256; ++n2) {
            this.d[n2] = 0;
            this.c[n2] = 0;
        }
        this.g = 0;
        this.f = 0;
        this.e = 0;
        this.h = 0;
        byte[] byArray2 = new byte[byArray.length + (byArray.length & 3)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        for (n2 = 0; n2 < byArray2.length; n2 += 4) {
            this.d[n2 >>> 2] = Pack.littleEndianToInt(byArray2, n2);
        }
        int[] nArray = new int[8];
        for (n2 = 0; n2 < 8; ++n2) {
            nArray[n2] = -1640531527;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.a(nArray);
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i2 = 0; i2 < 256; i2 += 8) {
                int n3;
                for (n3 = 0; n3 < 8; ++n3) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + (n2 < 1 ? this.d[i2 + n3] : this.c[i2 + n3]);
                }
                this.a(nArray);
                for (n3 = 0; n3 < 8; ++n3) {
                    this.c[i2 + n3] = nArray[n3];
                }
            }
        }
        this.a();
        this.k = true;
    }

    private void a() {
        this.f += ++this.g;
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2;
            int n3 = this.c[i2];
            switch (i2 & 3) {
                case 0: {
                    this.e ^= this.e << 13;
                    break;
                }
                case 1: {
                    this.e ^= this.e >>> 6;
                    break;
                }
                case 2: {
                    this.e ^= this.e << 2;
                    break;
                }
                case 3: {
                    this.e ^= this.e >>> 16;
                }
            }
            this.e += this.c[i2 + 128 & 0xFF];
            this.c[i2] = n2 = this.c[n3 >>> 2 & 0xFF] + this.e + this.f;
            this.d[i2] = this.f = this.c[n2 >>> 10 & 0xFF] + n3;
        }
    }

    private void a(int[] nArray) {
        nArray[0] = nArray[0] ^ nArray[1] << 11;
        nArray[3] = nArray[3] + nArray[0];
        nArray[1] = nArray[1] + nArray[2];
        nArray[1] = nArray[1] ^ nArray[2] >>> 2;
        nArray[4] = nArray[4] + nArray[1];
        nArray[2] = nArray[2] + nArray[3];
        nArray[2] = nArray[2] ^ nArray[3] << 8;
        nArray[5] = nArray[5] + nArray[2];
        nArray[3] = nArray[3] + nArray[4];
        nArray[3] = nArray[3] ^ nArray[4] >>> 16;
        nArray[6] = nArray[6] + nArray[3];
        nArray[4] = nArray[4] + nArray[5];
        nArray[4] = nArray[4] ^ nArray[5] << 10;
        nArray[7] = nArray[7] + nArray[4];
        nArray[5] = nArray[5] + nArray[6];
        nArray[5] = nArray[5] ^ nArray[6] >>> 4;
        nArray[0] = nArray[0] + nArray[5];
        nArray[6] = nArray[6] + nArray[7];
        nArray[6] = nArray[6] ^ nArray[7] << 8;
        nArray[1] = nArray[1] + nArray[6];
        nArray[7] = nArray[7] + nArray[0];
        nArray[7] = nArray[7] ^ nArray[0] >>> 9;
        nArray[2] = nArray[2] + nArray[7];
        nArray[0] = nArray[0] + nArray[1];
    }
}

