/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import java.security.SecureRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher a;
    private ParametersWithIV b;
    private boolean c;
    private SecureRandom d;

    public RFC3211WrapEngine(BlockCipher engine) {
        this.a = new CBCBlockCipher(engine);
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.c = forWrapping;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.d = parametersWithRandom.getRandom();
            this.b = (ParametersWithIV)parametersWithRandom.getParameters();
        } else {
            if (forWrapping) {
                this.d = CryptoServicesRegistrar.getSecureRandom();
            }
            this.b = (ParametersWithIV)param;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        int n2;
        if (!this.c) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.a.init(true, this.b);
        int n3 = this.a.getBlockSize();
        byte[] byArray = inLen + 4 < n3 * 2 ? new byte[n3 * 2] : new byte[(inLen + 4) % n3 == 0 ? inLen + 4 : ((inLen + 4) / n3 + 1) * n3];
        byArray[0] = (byte)inLen;
        byArray[1] = ~in[inOff];
        byArray[2] = ~in[inOff + 1];
        byArray[3] = ~in[inOff + 2];
        System.arraycopy(in, inOff, byArray, 4, inLen);
        byte[] byArray2 = new byte[byArray.length - (inLen + 4)];
        this.d.nextBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, inLen + 4, byArray2.length);
        for (n2 = 0; n2 < byArray.length; n2 += n3) {
            this.a.processBlock(byArray, n2, byArray, n2);
        }
        for (n2 = 0; n2 < byArray.length; n2 += n3) {
            this.a.processBlock(byArray, n2, byArray, n2);
        }
        return byArray;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        if (this.c) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n3 = this.a.getBlockSize();
        if (inLen < 2 * n3) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] byArray = new byte[inLen];
        byte[] byArray2 = new byte[n3];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        System.arraycopy(in, inOff, byArray2, 0, byArray2.length);
        this.a.init(false, new ParametersWithIV(this.b.getParameters(), byArray2));
        for (n2 = n3; n2 < byArray.length; n2 += n3) {
            this.a.processBlock(byArray, n2, byArray, n2);
        }
        System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
        this.a.init(false, new ParametersWithIV(this.b.getParameters(), byArray2));
        this.a.processBlock(byArray, 0, byArray, 0);
        this.a.init(false, this.b);
        for (n2 = 0; n2 < byArray.length; n2 += n3) {
            this.a.processBlock(byArray, n2, byArray, n2);
        }
        if ((byArray[0] & 0xFF) > byArray.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] byArray3 = new byte[byArray[0] & 0xFF];
        System.arraycopy(byArray, 4, byArray3, 0, byArray[0]);
        int n4 = 0;
        for (int i2 = 0; i2 != 3; ++i2) {
            byte by = ~byArray[1 + i2];
            n4 |= by ^ byArray3[i2];
        }
        if (n4 != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return byArray3;
    }
}

