/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.MaxBytesExceededException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.SkippingStreamCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Pack;
import com.enterprisedt.bouncycastle.util.Strings;

public class Salsa20Engine
implements SkippingStreamCipher {
    public static final int DEFAULT_ROUNDS = 20;
    private static final int[] a = Pack.littleEndianToInt(Strings.toByteArray("expand 16-byte kexpand 32-byte k"), 0, 8);
    protected static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    protected static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    protected int rounds;
    private int b = 0;
    protected int[] engineState = new int[16];
    protected int[] x = new int[16];
    private byte[] c = new byte[64];
    private boolean d = false;
    private int e;
    private int f;
    private int g;

    protected void packTauOrSigma(int keyLength, int[] state, int stateOffset) {
        int n2 = (keyLength - 16) / 4;
        state[stateOffset] = a[n2];
        state[stateOffset + 1] = a[n2 + 1];
        state[stateOffset + 2] = a[n2 + 2];
        state[stateOffset + 3] = a[n2 + 3];
    }

    public Salsa20Engine() {
        this(20);
    }

    public Salsa20Engine(int rounds) {
        if (rounds <= 0 || (rounds & 1) != 0) {
            throw new IllegalArgumentException("'rounds' must be a positive, even number");
        }
        this.rounds = rounds;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != this.getNonceSize()) {
            throw new IllegalArgumentException(this.getAlgorithmName() + " requires exactly " + this.getNonceSize() + " bytes of IV");
        }
        CipherParameters cipherParameters = parametersWithIV.getParameters();
        if (cipherParameters == null) {
            if (!this.d) {
                throw new IllegalStateException(this.getAlgorithmName() + " KeyParameter can not be null for first initialisation");
            }
            this.setKey(null, byArray);
        } else if (cipherParameters instanceof KeyParameter) {
            this.setKey(((KeyParameter)cipherParameters).getKey(), byArray);
        } else {
            throw new IllegalArgumentException(this.getAlgorithmName() + " Init parameters must contain a KeyParameter (or null for re-init)");
        }
        this.reset();
        this.d = true;
    }

    protected int getNonceSize() {
        return 8;
    }

    @Override
    public String getAlgorithmName() {
        String string = "Salsa20";
        if (this.rounds != 20) {
            string = string + "/" + this.rounds;
        }
        return string;
    }

    @Override
    public byte returnByte(byte in) {
        if (this.b()) {
            throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
        }
        byte by = (byte)(this.c[this.b] ^ in);
        this.b = this.b + 1 & 0x3F;
        if (this.b == 0) {
            this.advanceCounter();
            this.generateKeyStream(this.c);
        }
        return by;
    }

    protected void advanceCounter(long diff) {
        int n2 = (int)(diff >>> 32);
        int n3 = (int)diff;
        if (n2 > 0) {
            this.engineState[9] = this.engineState[9] + n2;
        }
        int n4 = this.engineState[8];
        this.engineState[8] = this.engineState[8] + n3;
        if (n4 != 0 && this.engineState[8] < n4) {
            this.engineState[9] = this.engineState[9] + 1;
        }
    }

    protected void advanceCounter() {
        this.engineState[8] = this.engineState[8] + 1;
        if (this.engineState[8] == 0) {
            this.engineState[9] = this.engineState[9] + 1;
        }
    }

    protected void retreatCounter(long diff) {
        int n2 = (int)(diff >>> 32);
        int n3 = (int)diff;
        if (n2 != 0) {
            if (((long)this.engineState[9] & 0xFFFFFFFFL) >= ((long)n2 & 0xFFFFFFFFL)) {
                this.engineState[9] = this.engineState[9] - n2;
            } else {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        if (((long)this.engineState[8] & 0xFFFFFFFFL) >= ((long)n3 & 0xFFFFFFFFL)) {
            this.engineState[8] = this.engineState[8] - n3;
        } else if (this.engineState[9] != 0) {
            this.engineState[9] = this.engineState[9] - 1;
            this.engineState[8] = this.engineState[8] - n3;
        } else {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
    }

    protected void retreatCounter() {
        if (this.engineState[8] == 0 && this.engineState[9] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[8] = this.engineState[8] - 1;
        if (this.engineState[8] == -1) {
            this.engineState[9] = this.engineState[9] - 1;
        }
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (!this.d) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.a(len)) {
            throw new MaxBytesExceededException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[i2 + outOff] = (byte)(this.c[this.b] ^ in[i2 + inOff]);
            this.b = this.b + 1 & 0x3F;
            if (this.b != 0) continue;
            this.advanceCounter();
            this.generateKeyStream(this.c);
        }
        return len;
    }

    @Override
    public long skip(long numberOfBytes) {
        if (numberOfBytes >= 0L) {
            long l2 = numberOfBytes;
            if (l2 >= 64L) {
                long l3 = l2 / 64L;
                this.advanceCounter(l3);
                l2 -= l3 * 64L;
            }
            int n2 = this.b;
            this.b = this.b + (int)l2 & 0x3F;
            if (this.b < n2) {
                this.advanceCounter();
            }
        } else {
            long l4;
            long l5 = -numberOfBytes;
            if (l5 >= 64L) {
                l4 = l5 / 64L;
                this.retreatCounter(l4);
                l5 -= l4 * 64L;
            }
            for (l4 = 0L; l4 < l5; ++l4) {
                if (this.b == 0) {
                    this.retreatCounter();
                }
                this.b = this.b - 1 & 0x3F;
            }
        }
        this.generateKeyStream(this.c);
        return numberOfBytes;
    }

    @Override
    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    @Override
    public long getPosition() {
        return this.getCounter() * 64L + (long)this.b;
    }

    @Override
    public void reset() {
        this.b = 0;
        this.a();
        this.resetCounter();
        this.generateKeyStream(this.c);
    }

    protected long getCounter() {
        return (long)this.engineState[9] << 32 | (long)this.engineState[8] & 0xFFFFFFFFL;
    }

    protected void resetCounter() {
        this.engineState[9] = 0;
        this.engineState[8] = 0;
    }

    protected void setKey(byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null) {
            if (keyBytes.length != 16 && keyBytes.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
            }
            int n2 = (keyBytes.length - 16) / 4;
            this.engineState[0] = a[n2];
            this.engineState[5] = a[n2 + 1];
            this.engineState[10] = a[n2 + 2];
            this.engineState[15] = a[n2 + 3];
            Pack.littleEndianToInt(keyBytes, 0, this.engineState, 1, 4);
            Pack.littleEndianToInt(keyBytes, keyBytes.length - 16, this.engineState, 11, 4);
        }
        Pack.littleEndianToInt(ivBytes, 0, this.engineState, 6, 2);
    }

    protected void generateKeyStream(byte[] output) {
        Salsa20Engine.salsaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, output, 0);
    }

    public static void salsaCore(int rounds, int[] input, int[] x2) {
        if (input.length != 16) {
            throw new IllegalArgumentException();
        }
        if (x2.length != 16) {
            throw new IllegalArgumentException();
        }
        if (rounds % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int n2 = input[0];
        int n3 = input[1];
        int n4 = input[2];
        int n5 = input[3];
        int n6 = input[4];
        int n7 = input[5];
        int n8 = input[6];
        int n9 = input[7];
        int n10 = input[8];
        int n11 = input[9];
        int n12 = input[10];
        int n13 = input[11];
        int n14 = input[12];
        int n15 = input[13];
        int n16 = input[14];
        int n17 = input[15];
        for (int i2 = rounds; i2 > 0; i2 -= 2) {
            n10 ^= Salsa20Engine.rotl((n6 ^= Salsa20Engine.rotl(n2 + n14, 7)) + n2, 9);
            n2 ^= Salsa20Engine.rotl((n14 ^= Salsa20Engine.rotl(n10 + n6, 13)) + n10, 18);
            n15 ^= Salsa20Engine.rotl((n11 ^= Salsa20Engine.rotl(n7 + n3, 7)) + n7, 9);
            n7 ^= Salsa20Engine.rotl((n3 ^= Salsa20Engine.rotl(n15 + n11, 13)) + n15, 18);
            n4 ^= Salsa20Engine.rotl((n16 ^= Salsa20Engine.rotl(n12 + n8, 7)) + n12, 9);
            n12 ^= Salsa20Engine.rotl((n8 ^= Salsa20Engine.rotl(n4 + n16, 13)) + n4, 18);
            n9 ^= Salsa20Engine.rotl((n5 ^= Salsa20Engine.rotl(n17 + n13, 7)) + n17, 9);
            n17 ^= Salsa20Engine.rotl((n13 ^= Salsa20Engine.rotl(n9 + n5, 13)) + n9, 18);
            n4 ^= Salsa20Engine.rotl((n3 ^= Salsa20Engine.rotl(n2 + n5, 7)) + n2, 9);
            n2 ^= Salsa20Engine.rotl((n5 ^= Salsa20Engine.rotl(n4 + n3, 13)) + n4, 18);
            n9 ^= Salsa20Engine.rotl((n8 ^= Salsa20Engine.rotl(n7 + n6, 7)) + n7, 9);
            n7 ^= Salsa20Engine.rotl((n6 ^= Salsa20Engine.rotl(n9 + n8, 13)) + n9, 18);
            n10 ^= Salsa20Engine.rotl((n13 ^= Salsa20Engine.rotl(n12 + n11, 7)) + n12, 9);
            n12 ^= Salsa20Engine.rotl((n11 ^= Salsa20Engine.rotl(n10 + n13, 13)) + n10, 18);
            n15 ^= Salsa20Engine.rotl((n14 ^= Salsa20Engine.rotl(n17 + n16, 7)) + n17, 9);
            n17 ^= Salsa20Engine.rotl((n16 ^= Salsa20Engine.rotl(n15 + n14, 13)) + n15, 18);
        }
        x2[0] = n2 + input[0];
        x2[1] = n3 + input[1];
        x2[2] = n4 + input[2];
        x2[3] = n5 + input[3];
        x2[4] = n6 + input[4];
        x2[5] = n7 + input[5];
        x2[6] = n8 + input[6];
        x2[7] = n9 + input[7];
        x2[8] = n10 + input[8];
        x2[9] = n11 + input[9];
        x2[10] = n12 + input[10];
        x2[11] = n13 + input[11];
        x2[12] = n14 + input[12];
        x2[13] = n15 + input[13];
        x2[14] = n16 + input[14];
        x2[15] = n17 + input[15];
    }

    protected static int rotl(int x2, int y2) {
        return x2 << y2 | x2 >>> -y2;
    }

    private void a() {
        this.e = 0;
        this.f = 0;
        this.g = 0;
    }

    private boolean b() {
        if (++this.e == 0 && ++this.f == 0) {
            return (++this.g & 0x20) != 0;
        }
        return false;
    }

    private boolean a(int n2) {
        this.e += n2;
        if (this.e < n2 && this.e >= 0 && ++this.f == 0) {
            return (++this.g & 0x20) != 0;
        }
        return false;
    }
}

