/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public abstract class SerpentEngineBase
implements BlockCipher {
    protected static final int BLOCK_SIZE = 16;
    protected boolean encrypting;
    protected int[] wKey;
    protected int X0;
    protected int X1;
    protected int X2;
    protected int X3;

    SerpentEngineBase() {
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.encrypting = encrypting;
            this.wKey = this.makeWorkingKey(((KeyParameter)params).getKey());
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to " + this.getAlgorithmName() + " init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "Serpent";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public final int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.wKey == null) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 16;
    }

    @Override
    public void reset() {
    }

    protected static int rotateLeft(int x2, int bits) {
        return x2 << bits | x2 >>> -bits;
    }

    protected static int rotateRight(int x2, int bits) {
        return x2 >>> bits | x2 << -bits;
    }

    protected final void sb0(int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ d2;
        int n3 = c2 ^ n2;
        int n4 = b2 ^ n3;
        this.X3 = a2 & d2 ^ n4;
        int n5 = a2 ^ b2 & n2;
        this.X2 = n4 ^ (c2 | n5);
        int n6 = this.X3 & (n3 ^ n5);
        this.X1 = ~n3 ^ n6;
        this.X0 = n6 ^ ~n5;
    }

    protected final void ib0(int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = d2 ^ (n2 | n3);
        int n5 = c2 ^ n4;
        this.X2 = n3 ^ n5;
        int n6 = n2 ^ d2 & n3;
        this.X1 = n4 ^ this.X2 & n6;
        this.X3 = a2 & n4 ^ (n5 | this.X1);
        this.X0 = this.X3 ^ (n5 ^ n6);
    }

    protected final void sb1(int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ ~a2;
        int n3 = c2 ^ (a2 | n2);
        this.X2 = d2 ^ n3;
        int n4 = b2 ^ (d2 | n2);
        int n5 = n2 ^ this.X2;
        this.X3 = n5 ^ n3 & n4;
        int n6 = n3 ^ n4;
        this.X1 = this.X3 ^ n6;
        this.X0 = n3 ^ n5 & n6;
    }

    protected final void ib1(int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ d2;
        int n3 = a2 ^ b2 & n2;
        int n4 = n2 ^ n3;
        this.X3 = c2 ^ n4;
        int n5 = b2 ^ n2 & n3;
        int n6 = this.X3 | n5;
        this.X1 = n3 ^ n6;
        int n7 = ~this.X1;
        int n8 = this.X3 ^ n5;
        this.X0 = n7 ^ n8;
        this.X2 = n4 ^ (n7 | n8);
    }

    protected final void sb2(int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = b2 ^ d2;
        int n4 = c2 & n2;
        this.X0 = n3 ^ n4;
        int n5 = c2 ^ n2;
        int n6 = c2 ^ this.X0;
        int n7 = b2 & n6;
        this.X3 = n5 ^ n7;
        this.X2 = a2 ^ (d2 | n7) & (this.X0 | n5);
        this.X1 = n3 ^ this.X3 ^ (this.X2 ^ (d2 | n2));
    }

    protected final void ib2(int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ d2;
        int n3 = ~n2;
        int n4 = a2 ^ c2;
        int n5 = c2 ^ n2;
        int n6 = b2 & n5;
        this.X0 = n4 ^ n6;
        int n7 = a2 | n3;
        int n8 = d2 ^ n7;
        int n9 = n4 | n8;
        this.X3 = n2 ^ n9;
        int n10 = ~n5;
        int n11 = this.X0 | this.X3;
        this.X1 = n10 ^ n11;
        this.X2 = d2 & n10 ^ (n4 ^ n11);
    }

    protected final void sb3(int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ b2;
        int n3 = a2 & c2;
        int n4 = a2 | d2;
        int n5 = c2 ^ d2;
        int n6 = n2 & n4;
        int n7 = n3 | n6;
        this.X2 = n5 ^ n7;
        int n8 = b2 ^ n4;
        int n9 = n7 ^ n8;
        int n10 = n5 & n9;
        this.X0 = n2 ^ n10;
        int n11 = this.X2 & this.X0;
        this.X1 = n9 ^ n11;
        this.X3 = (b2 | d2) ^ (n5 ^ n11);
    }

    protected final void ib3(int a2, int b2, int c2, int d2) {
        int n2 = a2 | b2;
        int n3 = b2 ^ c2;
        int n4 = b2 & n3;
        int n5 = a2 ^ n4;
        int n6 = c2 ^ n5;
        int n7 = d2 | n5;
        this.X0 = n3 ^ n7;
        int n8 = n3 | n7;
        int n9 = d2 ^ n8;
        this.X2 = n6 ^ n9;
        int n10 = n2 ^ n9;
        int n11 = this.X0 & n10;
        this.X3 = n5 ^ n11;
        this.X1 = this.X3 ^ (this.X0 ^ n10);
    }

    protected final void sb4(int a2, int b2, int c2, int d2) {
        int n2 = a2 ^ d2;
        int n3 = d2 & n2;
        int n4 = c2 ^ n3;
        int n5 = b2 | n4;
        this.X3 = n2 ^ n5;
        int n6 = ~b2;
        int n7 = n2 | n6;
        this.X0 = n4 ^ n7;
        int n8 = a2 & this.X0;
        int n9 = n2 ^ n6;
        int n10 = n5 & n9;
        this.X2 = n8 ^ n10;
        this.X1 = a2 ^ n4 ^ n9 & this.X2;
    }

    protected final void ib4(int a2, int b2, int c2, int d2) {
        int n2 = c2 | d2;
        int n3 = a2 & n2;
        int n4 = b2 ^ n3;
        int n5 = a2 & n4;
        int n6 = c2 ^ n5;
        this.X1 = d2 ^ n6;
        int n7 = ~a2;
        int n8 = n6 & this.X1;
        this.X3 = n4 ^ n8;
        int n9 = this.X1 | n7;
        int n10 = d2 ^ n9;
        this.X0 = this.X3 ^ n10;
        this.X2 = n4 & n10 ^ (this.X1 ^ n7);
    }

    protected final void sb5(int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = a2 ^ d2;
        int n5 = c2 ^ n2;
        int n6 = n3 | n4;
        this.X0 = n5 ^ n6;
        int n7 = d2 & this.X0;
        int n8 = n3 ^ this.X0;
        this.X1 = n7 ^ n8;
        int n9 = n2 | this.X0;
        int n10 = n3 | n7;
        int n11 = n4 ^ n9;
        this.X2 = n10 ^ n11;
        this.X3 = b2 ^ n7 ^ this.X1 & n11;
    }

    protected final void ib5(int a2, int b2, int c2, int d2) {
        int n2 = ~c2;
        int n3 = b2 & n2;
        int n4 = d2 ^ n3;
        int n5 = a2 & n4;
        int n6 = b2 ^ n2;
        this.X3 = n5 ^ n6;
        int n7 = b2 | this.X3;
        int n8 = a2 & n7;
        this.X1 = n4 ^ n8;
        int n9 = a2 | d2;
        int n10 = n2 ^ n7;
        this.X0 = n9 ^ n10;
        this.X2 = b2 & n9 ^ (n5 | a2 ^ c2);
    }

    protected final void sb6(int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ d2;
        int n4 = b2 ^ n3;
        int n5 = n2 | n3;
        int n6 = c2 ^ n5;
        this.X1 = b2 ^ n6;
        int n7 = n3 | this.X1;
        int n8 = d2 ^ n7;
        int n9 = n6 & n8;
        this.X2 = n4 ^ n9;
        int n10 = n6 ^ n8;
        this.X0 = this.X2 ^ n10;
        this.X3 = ~n6 ^ n4 & n10;
    }

    protected final void ib6(int a2, int b2, int c2, int d2) {
        int n2 = ~a2;
        int n3 = a2 ^ b2;
        int n4 = c2 ^ n3;
        int n5 = c2 | n2;
        int n6 = d2 ^ n5;
        this.X1 = n4 ^ n6;
        int n7 = n4 & n6;
        int n8 = n3 ^ n7;
        int n9 = b2 | n8;
        this.X3 = n6 ^ n9;
        int n10 = b2 | this.X3;
        this.X0 = n8 ^ n10;
        this.X2 = d2 & n2 ^ (n4 ^ n10);
    }

    protected final void sb7(int a2, int b2, int c2, int d2) {
        int n2 = b2 ^ c2;
        int n3 = c2 & n2;
        int n4 = d2 ^ n3;
        int n5 = a2 ^ n4;
        int n6 = d2 | n2;
        int n7 = n5 & n6;
        this.X1 = b2 ^ n7;
        int n8 = n4 | this.X1;
        int n9 = a2 & n5;
        this.X3 = n2 ^ n9;
        int n10 = n5 ^ n8;
        int n11 = this.X3 & n10;
        this.X2 = n4 ^ n11;
        this.X0 = ~n10 ^ this.X3 & this.X2;
    }

    protected final void ib7(int a2, int b2, int c2, int d2) {
        int n2 = c2 | a2 & b2;
        int n3 = d2 & (a2 | b2);
        this.X3 = n2 ^ n3;
        int n4 = ~d2;
        int n5 = b2 ^ n3;
        int n6 = n5 | this.X3 ^ n4;
        this.X1 = a2 ^ n6;
        this.X0 = c2 ^ n5 ^ (d2 | this.X1);
        this.X2 = n2 ^ this.X1 ^ (this.X0 ^ a2 & this.X3);
    }

    protected final void LT() {
        int n2 = SerpentEngineBase.rotateLeft(this.X0, 13);
        int n3 = SerpentEngineBase.rotateLeft(this.X2, 3);
        int n4 = this.X1 ^ n2 ^ n3;
        int n5 = this.X3 ^ n3 ^ n2 << 3;
        this.X1 = SerpentEngineBase.rotateLeft(n4, 1);
        this.X3 = SerpentEngineBase.rotateLeft(n5, 7);
        this.X0 = SerpentEngineBase.rotateLeft(n2 ^ this.X1 ^ this.X3, 5);
        this.X2 = SerpentEngineBase.rotateLeft(n3 ^ this.X3 ^ this.X1 << 7, 22);
    }

    protected final void inverseLT() {
        int n2 = SerpentEngineBase.rotateRight(this.X2, 22) ^ this.X3 ^ this.X1 << 7;
        int n3 = SerpentEngineBase.rotateRight(this.X0, 5) ^ this.X1 ^ this.X3;
        int n4 = SerpentEngineBase.rotateRight(this.X3, 7);
        int n5 = SerpentEngineBase.rotateRight(this.X1, 1);
        this.X3 = n4 ^ n2 ^ n3 << 3;
        this.X1 = n5 ^ n3 ^ n2;
        this.X2 = SerpentEngineBase.rotateRight(n2, 3);
        this.X0 = SerpentEngineBase.rotateRight(n3, 13);
    }

    protected abstract int[] makeWorkingKey(byte[] var1);

    protected abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);
}

