/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class TEAEngine
implements BlockCipher {
    private int a;
    private int b;
    private int c;
    private int d;
    private boolean e = false;
    private boolean f;

    @Override
    public String getAlgorithmName() {
        return "TEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + params.getClass().getName());
        }
        this.f = forEncryption;
        this.e = true;
        KeyParameter keyParameter = (KeyParameter)params;
        this.a(keyParameter.getKey());
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this.e) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this.f ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
    }

    private void a(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Key size must be 128 bits.");
        }
        this.a = this.a(byArray, 0);
        this.b = this.a(byArray, 4);
        this.c = this.a(byArray, 8);
        this.d = this.a(byArray, 12);
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        int n6 = 0;
        for (int i2 = 0; i2 != 32; ++i2) {
            n5 += ((n4 += (n5 << 4) + this.a ^ n5 + (n6 -= 1640531527) ^ (n5 >>> 5) + this.b) << 4) + this.c ^ n4 + n6 ^ (n4 >>> 5) + this.d;
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        int n6 = -957401312;
        for (int i2 = 0; i2 != 32; ++i2) {
            n4 -= ((n5 -= (n4 << 4) + this.c ^ n4 + n6 ^ (n4 >>> 5) + this.d) << 4) + this.a ^ n5 + n6 ^ (n5 >>> 5) + this.b;
            n6 += 1640531527;
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int a(byte[] byArray, int n2) {
        return byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }
}

