/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private int[] a = new int[4];
    private int[] b = new int[32];
    private int[] c = new int[32];
    private boolean d = false;
    private boolean e;

    @Override
    public String getAlgorithmName() {
        return "XTEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + params.getClass().getName());
        }
        this.e = forEncryption;
        this.d = true;
        KeyParameter keyParameter = (KeyParameter)params;
        this.a(keyParameter.getKey());
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this.d) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this.e ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
    }

    private void a(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Key size must be 128 bits.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            this.a[n3] = this.a(byArray, n2);
            ++n3;
            n2 += 4;
        }
        n2 = 0;
        for (n3 = 0; n3 < 32; ++n3) {
            this.b[n3] = n2 + this.a[n2 & 3];
            this.c[n3] = (n2 -= 1640531527) + this.a[n2 >>> 11 & 3];
        }
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        for (int i2 = 0; i2 < 32; ++i2) {
            n5 += ((n4 += (n5 << 4 ^ n5 >>> 5) + n5 ^ this.b[i2]) << 4 ^ n4 >>> 5) + n4 ^ this.c[i2];
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        for (int i2 = 31; i2 >= 0; --i2) {
            n4 -= ((n5 -= (n4 << 4 ^ n4 >>> 5) + n4 ^ this.c[i2]) << 4 ^ n5 >>> 5) + n5 ^ this.b[i2];
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int a(byte[] byArray, int n2) {
        return byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }
}

