/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.DigestDerivationFunction;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.util.Pack;

public class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int a;
    private Digest b;
    private byte[] c;
    private byte[] d;

    protected BaseKDFBytesGenerator(int counterStart, Digest digest) {
        this.a = counterStart;
        this.b = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        if (param instanceof KDFParameters) {
            KDFParameters kDFParameters = (KDFParameters)param;
            this.c = kDFParameters.getSharedSecret();
            this.d = kDFParameters.getIV();
        } else if (param instanceof ISO18033KDFParameters) {
            ISO18033KDFParameters iSO18033KDFParameters = (ISO18033KDFParameters)param;
            this.c = iSO18033KDFParameters.getSeed();
            this.d = null;
        } else {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
    }

    @Override
    public Digest getDigest() {
        return this.b;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new OutputLengthException("output buffer too small");
        }
        long l2 = len;
        int n2 = this.b.getDigestSize();
        if (l2 > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int n3 = (int)((l2 + (long)n2 - 1L) / (long)n2);
        byte[] byArray = new byte[this.b.getDigestSize()];
        byte[] byArray2 = new byte[4];
        Pack.intToBigEndian(this.a, byArray2, 0);
        int n4 = this.a & 0xFFFFFF00;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.b.update(this.c, 0, this.c.length);
            this.b.update(byArray2, 0, byArray2.length);
            if (this.d != null) {
                this.b.update(this.d, 0, this.d.length);
            }
            this.b.doFinal(byArray, 0);
            if (len > n2) {
                System.arraycopy(byArray, 0, out, outOff, n2);
                outOff += n2;
                len -= n2;
            } else {
                System.arraycopy(byArray, 0, out, outOff, len);
            }
            byArray2[3] = (byte)(byArray2[3] + 1);
            if (byArray2[3] != 0) continue;
            Pack.intToBigEndian(n4 += 256, byArray2, 0);
        }
        this.b.reset();
        return (int)l2;
    }
}

