/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.CipherKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters param) {
        super.init(param);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (DESParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

