/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.generators.DESKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.params.DESedeParameters;

public class DESedeKeyGenerator
extends DESKeyGenerator {
    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.strength = (param.getStrength() + 7) / 8;
        if (this.strength == 0 || this.strength == 21) {
            this.strength = 24;
        } else if (this.strength == 14) {
            this.strength = 16;
        } else if (this.strength != 24 && this.strength != 16) {
            throw new IllegalArgumentException("DESede key must be 192 or 128 bits long.");
        }
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = new byte[this.strength];
        int n2 = 0;
        do {
            this.random.nextBytes(byArray);
            DESedeParameters.setOddParity(byArray);
        } while (++n2 < 20 && (DESedeParameters.isWeakKey(byArray, 0, byArray.length) || !DESedeParameters.isRealEDEKey(byArray, 0)));
        if (DESedeParameters.isWeakKey(byArray, 0, byArray.length) || !DESedeParameters.isRealEDEKey(byArray, 0)) {
            throw new IllegalStateException("Unable to generate DES-EDE key");
        }
        return byArray;
    }
}

