/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.KeyEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DerivationFunction b;
    private SecureRandom c;
    private ECKeyParameters d;
    private boolean e;
    private boolean f;
    private boolean g;

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.b = kdf;
        this.c = rnd;
        this.e = false;
        this.f = false;
        this.g = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.b = kdf;
        this.c = rnd;
        this.e = cofactorMode;
        this.f = oldCofactorMode;
        this.g = singleHashMode;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.d = (ECKeyParameters)key;
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (!(this.d instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.d;
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger, this.c);
        BigInteger bigInteger4 = this.e ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3), eCPublicKeyParameters.getQ().multiply(bigInteger4)};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint eCPoint = eCPointArray[0];
        ECPoint eCPoint2 = eCPointArray[1];
        byte[] byArray = eCPoint.getEncoded(false);
        System.arraycopy(byArray, 0, out, outOff, byArray.length);
        byte[] byArray2 = eCPoint2.getAffineXCoord().getEncoded();
        return this.deriveKey(keyLen, byArray, byArray2);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        ECPoint eCPoint;
        if (!(this.d instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.d;
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        byte[] byArray = new byte[inLen];
        System.arraycopy(in, inOff, byArray, 0, inLen);
        ECPoint eCPoint2 = eCPoint = eCCurve.decodePoint(byArray);
        if (this.e || this.f) {
            eCPoint2 = eCPoint2.multiply(bigInteger2);
        }
        BigInteger bigInteger3 = eCPrivateKeyParameters.getD();
        if (this.e) {
            bigInteger3 = bigInteger3.multiply(bigInteger2.modInverse(bigInteger)).mod(bigInteger);
        }
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger3).normalize();
        byte[] byArray2 = eCPoint3.getAffineXCoord().getEncoded();
        return this.deriveKey(keyLen, byArray, byArray2);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyParameter deriveKey(int keyLen, byte[] C, byte[] PEH) {
        byte[] byArray = PEH;
        if (!this.g) {
            byArray = Arrays.concatenate(C, PEH);
            Arrays.fill(PEH, (byte)0);
        }
        try {
            this.b.init(new KDFParameters(byArray, null));
            byte[] byArray2 = new byte[keyLen];
            this.b.generateBytes(byArray2, 0, byArray2.length);
            KeyParameter keyParameter = new KeyParameter(byArray2);
            return keyParameter;
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }
}

