/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CBCBlockCipherMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private BlockCipher d;
    private BlockCipherPadding e;
    private int f;

    public CBCBlockCipherMac(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8 / 2, null);
    }

    public CBCBlockCipherMac(BlockCipher cipher, BlockCipherPadding padding) {
        this(cipher, cipher.getBlockSize() * 8 / 2, padding);
    }

    public CBCBlockCipherMac(BlockCipher cipher, int macSizeInBits) {
        this(cipher, macSizeInBits, null);
    }

    public CBCBlockCipherMac(BlockCipher cipher, int macSizeInBits, BlockCipherPadding padding) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.d = new CBCBlockCipher(cipher);
        this.e = padding;
        this.f = macSizeInBits / 8;
        this.a = new byte[cipher.getBlockSize()];
        this.b = new byte[cipher.getBlockSize()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.getAlgorithmName();
    }

    @Override
    public void init(CipherParameters params) {
        this.reset();
        this.d.init(true, params);
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte in) {
        if (this.c == this.b.length) {
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.d.getBlockSize();
        int n3 = n2 - this.c;
        if (len > n3) {
            System.arraycopy(in, inOff, this.b, this.c, n3);
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
            len -= n3;
            inOff += n3;
            while (len > n2) {
                this.d.processBlock(in, inOff, this.a, 0);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.b, this.c, len);
        this.c += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int n2 = this.d.getBlockSize();
        if (this.e == null) {
            while (this.c < n2) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            if (this.c == n2) {
                this.d.processBlock(this.b, 0, this.a, 0);
                this.c = 0;
            }
            this.e.addPadding(this.b, this.c);
        }
        this.d.processBlock(this.b, 0, this.a, 0);
        System.arraycopy(this.a, 0, out, outOff, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.reset();
    }
}

