/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CBCBlockCipher
implements BlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;
    private BlockCipher e = null;
    private boolean f;

    public CBCBlockCipher(BlockCipher cipher) {
        this.e = cipher;
        this.d = cipher.getBlockSize();
        this.a = new byte[this.d];
        this.b = new byte[this.d];
        this.c = new byte[this.d];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.e;
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) throws IllegalArgumentException {
        boolean bl = this.f;
        this.f = encrypting;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length != this.d) {
                throw new IllegalArgumentException("initialisation vector must be the same length as block size");
            }
            System.arraycopy(byArray, 0, this.a, 0, byArray.length);
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.e.init(encrypting, parametersWithIV.getParameters());
            } else if (bl != encrypting) {
                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
            }
        } else {
            this.reset();
            if (params != null) {
                this.e.init(encrypting, params);
            } else if (bl != encrypting) {
                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.e.getAlgorithmName() + "/CBC";
    }

    @Override
    public int getBlockSize() {
        return this.e.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        return this.f ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
        System.arraycopy(this.a, 0, this.b, 0, this.a.length);
        Arrays.fill(this.c, (byte)0);
        this.e.reset();
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        if (n2 + this.d > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        for (n4 = 0; n4 < this.d; ++n4) {
            int n5 = n4;
            this.b[n5] = (byte)(this.b[n5] ^ byArray[n2 + n4]);
        }
        n4 = this.e.processBlock(this.b, 0, byArray2, n3);
        System.arraycopy(byArray2, n3, this.b, 0, this.b.length);
        return n4;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.d > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        System.arraycopy(byArray, n2, this.c, 0, this.d);
        int n4 = this.e.processBlock(byArray, n2, byArray2, n3);
        for (int i2 = 0; i2 < this.d; ++i2) {
            int n5 = n3 + i2;
            byArray2[n5] = (byte)(byArray2[n5] ^ this.b[i2]);
        }
        byte[] byArray3 = this.b;
        this.b = this.c;
        this.c = byArray3;
        return n4;
    }
}

