/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CFBBlockCipher
extends StreamBlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private int e;
    private BlockCipher f = null;
    private boolean g;
    private int h;

    public CFBBlockCipher(BlockCipher cipher, int bitBlockSize) {
        super(cipher);
        this.f = cipher;
        this.e = bitBlockSize / 8;
        this.a = new byte[cipher.getBlockSize()];
        this.b = new byte[cipher.getBlockSize()];
        this.c = new byte[cipher.getBlockSize()];
        this.d = new byte[this.e];
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) throws IllegalArgumentException {
        this.g = encrypting;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.a.length) {
                System.arraycopy(byArray, 0, this.a, this.a.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.a.length - byArray.length; ++i2) {
                    this.a[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.a, 0, this.a.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (params != null) {
                this.f.init(true, params);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/CFB" + this.e * 8;
    }

    @Override
    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        return this.g ? this.a(in) : this.b(in);
    }

    private byte a(byte by) {
        if (this.h == 0) {
            this.f.processBlock(this.b, 0, this.c, 0);
        }
        byte by2 = (byte)(this.c[this.h] ^ by);
        this.d[this.h++] = by2;
        if (this.h == this.e) {
            this.h = 0;
            System.arraycopy(this.b, this.e, this.b, 0, this.b.length - this.e);
            System.arraycopy(this.d, 0, this.b, this.b.length - this.e, this.e);
        }
        return by2;
    }

    private byte b(byte by) {
        if (this.h == 0) {
            this.f.processBlock(this.b, 0, this.c, 0);
        }
        this.d[this.h] = by;
        byte by2 = (byte)(this.c[this.h++] ^ by);
        if (this.h == this.e) {
            this.h = 0;
            System.arraycopy(this.b, this.e, this.b, 0, this.b.length - this.e);
            System.arraycopy(this.d, 0, this.b, this.b.length - this.e, this.e);
        }
        return by2;
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.e, out, outOff);
        return this.e;
    }

    public int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.e, out, outOff);
        return this.e;
    }

    public int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.e, out, outOff);
        return this.e;
    }

    public byte[] getCurrentIV() {
        return Arrays.clone(this.b);
    }

    @Override
    public void reset() {
        System.arraycopy(this.a, 0, this.b, 0, this.a.length);
        Arrays.fill(this.d, (byte)0);
        this.h = 0;
        this.f.reset();
    }
}

