/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.BasicGCMExponentiator;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.Tables4kGCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class GCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher a;
    private GCMMultiplier b;
    private GCMExponentiator c;
    private boolean d;
    private boolean e;
    private int f;
    private byte[] g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private byte[] n;
    private byte[] o;
    private byte[] p;
    private byte[] q;
    private int r;
    private int s;
    private long t;
    private byte[] u;
    private int v;
    private long w;
    private long x;

    public GCMBlockCipher(BlockCipher c2) {
        this(c2, null);
    }

    public GCMBlockCipher(BlockCipher c2, GCMMultiplier m2) {
        if (c2.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (m2 == null) {
            m2 = new Tables4kGCMMultiplier();
        }
        this.a = c2;
        this.b = m2;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/GCM";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        KeyParameter keyParameter;
        CipherParameters cipherParameters;
        this.d = forEncryption;
        this.m = null;
        this.e = true;
        byte[] byArray = null;
        if (params instanceof AEADParameters) {
            cipherParameters = (AEADParameters)params;
            byArray = ((AEADParameters)cipherParameters).getNonce();
            this.i = ((AEADParameters)cipherParameters).getAssociatedText();
            int n2 = ((AEADParameters)cipherParameters).getMacSize();
            if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.f = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters).getKey();
        } else if (params instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)params;
            byArray = ((ParametersWithIV)cipherParameters).getIV();
            this.i = null;
            this.f = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = forEncryption ? 16 : 16 + this.f;
        this.l = new byte[n3];
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (forEncryption && this.h != null && Arrays.areEqual(this.h, byArray)) {
            if (keyParameter == null) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
            if (this.g != null && Arrays.areEqual(this.g, keyParameter.getKey())) {
                throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
            }
        }
        this.h = byArray;
        if (keyParameter != null) {
            this.g = keyParameter.getKey();
        }
        if (keyParameter != null) {
            this.a.init(true, keyParameter);
            this.j = new byte[16];
            this.a.processBlock(this.j, 0, this.j, 0);
            this.b.init(this.j);
            this.c = null;
        } else if (this.j == null) {
            throw new IllegalArgumentException("Key must be specified in initial init");
        }
        this.k = new byte[16];
        if (this.h.length == 12) {
            System.arraycopy(this.h, 0, this.k, 0, this.h.length);
            this.k[15] = 1;
        } else {
            this.a(this.k, this.h, this.h.length);
            byte[] byArray2 = new byte[16];
            Pack.longToBigEndian((long)this.h.length * 8L, byArray2, 8);
            this.a(this.k, byArray2);
        }
        this.n = new byte[16];
        this.o = new byte[16];
        this.p = new byte[16];
        this.u = new byte[16];
        this.v = 0;
        this.w = 0L;
        this.x = 0L;
        this.q = Arrays.clone(this.k);
        this.r = -2;
        this.s = 0;
        this.t = 0L;
        if (this.i != null) {
            this.processAADBytes(this.i, 0, this.i.length);
        }
    }

    @Override
    public byte[] getMac() {
        if (this.m == null) {
            return new byte[this.f];
        }
        return Arrays.clone(this.m);
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.s;
        if (this.d) {
            return n2 + this.f;
        }
        return n2 < this.f ? 0 : n2 - this.f;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = len + this.s;
        if (!this.d) {
            if (n2 < this.f) {
                return 0;
            }
            n2 -= this.f;
        }
        return n2 - n2 % 16;
    }

    @Override
    public void processAADByte(byte in) {
        this.b();
        this.u[this.v] = in;
        if (++this.v == 16) {
            this.a(this.o, this.u);
            this.v = 0;
            this.w += 16L;
        }
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.b();
        for (int i2 = 0; i2 < len; ++i2) {
            this.u[this.v] = in[inOff + i2];
            if (++this.v != 16) continue;
            this.a(this.o, this.u);
            this.v = 0;
            this.w += 16L;
        }
    }

    private void a() {
        if (this.w > 0L) {
            System.arraycopy(this.o, 0, this.p, 0, 16);
            this.x = this.w;
        }
        if (this.v > 0) {
            this.a(this.p, this.u, 0, this.v);
            this.x += (long)this.v;
        }
        if (this.x > 0L) {
            System.arraycopy(this.p, 0, this.n, 0, 16);
        }
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        this.b();
        this.l[this.s] = in;
        if (++this.s == this.l.length) {
            this.a(this.l, 0, out, outOff);
            if (this.d) {
                this.s = 0;
            } else {
                System.arraycopy(this.l, 16, this.l, 0, this.f);
                this.s = this.f;
            }
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        this.b();
        if (in.length - inOff < len) {
            throw new DataLengthException("Input buffer too short");
        }
        int n2 = 0;
        if (this.d) {
            if (this.s != 0) {
                while (len > 0) {
                    --len;
                    this.l[this.s] = in[inOff++];
                    if (++this.s != 16) continue;
                    this.a(this.l, 0, out, outOff);
                    this.s = 0;
                    n2 += 16;
                    break;
                }
            }
            while (len >= 16) {
                this.a(in, inOff, out, outOff + n2);
                inOff += 16;
                len -= 16;
                n2 += 16;
            }
            if (len > 0) {
                System.arraycopy(in, inOff, this.l, 0, len);
                this.s = len;
            }
        } else {
            for (int i2 = 0; i2 < len; ++i2) {
                this.l[this.s] = in[inOff + i2];
                if (++this.s != this.l.length) continue;
                this.a(this.l, 0, out, outOff + n2);
                System.arraycopy(this.l, 16, this.l, 0, this.f);
                this.s = this.f;
                n2 += 16;
            }
        }
        return n2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        this.b();
        if (this.t == 0L) {
            this.a();
        }
        int n2 = this.s;
        if (this.d) {
            if (out.length - outOff < n2 + this.f) {
                throw new OutputLengthException("Output buffer too short");
            }
        } else {
            if (n2 < this.f) {
                throw new InvalidCipherTextException("data too short");
            }
            if (out.length - outOff < (n2 -= this.f)) {
                throw new OutputLengthException("Output buffer too short");
            }
        }
        if (n2 > 0) {
            this.a(this.l, 0, n2, out, outOff);
        }
        this.w += (long)this.v;
        if (this.w > this.x) {
            if (this.v > 0) {
                this.a(this.o, this.u, 0, this.v);
            }
            if (this.x > 0L) {
                GCMUtil.xor(this.o, this.p);
            }
            long l2 = this.t * 8L + 127L >>> 7;
            byte[] byArray = new byte[16];
            if (this.c == null) {
                this.c = new BasicGCMExponentiator();
                this.c.init(this.j);
            }
            this.c.exponentiateX(l2, byArray);
            GCMUtil.multiply(this.o, byArray);
            GCMUtil.xor(this.n, this.o);
        }
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(this.w * 8L, byArray, 0);
        Pack.longToBigEndian(this.t * 8L, byArray, 8);
        this.a(this.n, byArray);
        byte[] byArray2 = new byte[16];
        this.a.processBlock(this.k, 0, byArray2, 0);
        GCMUtil.xor(byArray2, this.n);
        int n3 = n2;
        this.m = new byte[this.f];
        System.arraycopy(byArray2, 0, this.m, 0, this.f);
        if (this.d) {
            System.arraycopy(this.m, 0, out, outOff + this.s, this.f);
            n3 += this.f;
        } else {
            byte[] byArray3 = new byte[this.f];
            System.arraycopy(this.l, n2, byArray3, 0, this.f);
            if (!Arrays.constantTimeAreEqual(this.m, byArray3)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.a(false);
        return n3;
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl) {
        this.a.reset();
        this.n = new byte[16];
        this.o = new byte[16];
        this.p = new byte[16];
        this.u = new byte[16];
        this.v = 0;
        this.w = 0L;
        this.x = 0L;
        this.q = Arrays.clone(this.k);
        this.r = -2;
        this.s = 0;
        this.t = 0L;
        if (this.l != null) {
            Arrays.fill(this.l, (byte)0);
        }
        if (bl) {
            this.m = null;
        }
        if (this.d) {
            this.e = false;
        } else if (this.i != null) {
            this.processAADBytes(this.i, 0, this.i.length);
        }
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (byArray2.length - n3 < 16) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.t == 0L) {
            this.a();
        }
        byte[] byArray3 = new byte[16];
        this.a(byArray3);
        if (this.d) {
            GCMUtil.xor(byArray3, byArray, n2);
            this.a(this.n, byArray3);
            System.arraycopy(byArray3, 0, byArray2, n3, 16);
        } else {
            this.b(this.n, byArray, n2);
            GCMUtil.xor(byArray3, 0, byArray, n2, byArray2, n3);
        }
        this.t += 16L;
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[16];
        this.a(byArray3);
        if (this.d) {
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
            this.a(this.n, byArray, n2, n3);
        } else {
            this.a(this.n, byArray, n2, n3);
            GCMUtil.xor(byArray, n2, byArray3, 0, n3);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        this.t += (long)n3;
    }

    private void a(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.a(byArray, byArray2, i2, n3);
        }
    }

    private void a(byte[] byArray, byte[] byArray2) {
        GCMUtil.xor(byArray, byArray2);
        this.b.multiplyH(byArray);
    }

    private void b(byte[] byArray, byte[] byArray2, int n2) {
        GCMUtil.xor(byArray, byArray2, n2);
        this.b.multiplyH(byArray);
    }

    private void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        GCMUtil.xor(byArray, byArray2, n2, n3);
        this.b.multiplyH(byArray);
    }

    private void a(byte[] byArray) {
        if (this.r == 0) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        --this.r;
        int n2 = 1;
        this.q[15] = (byte)(n2 += this.q[15] & 0xFF);
        n2 >>>= 8;
        this.q[14] = (byte)(n2 += this.q[14] & 0xFF);
        n2 >>>= 8;
        this.q[13] = (byte)(n2 += this.q[13] & 0xFF);
        n2 >>>= 8;
        this.q[12] = (byte)(n2 += this.q[12] & 0xFF);
        this.a.processBlock(this.q, 0, byArray, 0);
    }

    private void b() {
        if (!this.e) {
            if (this.d) {
                throw new IllegalStateException("GCM cipher cannot be reused for encryption");
            }
            throw new IllegalStateException("GCM cipher needs to be initialised");
        }
    }
}

