/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private final int h;
    private final BlockCipher i;
    boolean a = true;
    int b;
    int c;

    public GOFBBlockCipher(BlockCipher cipher) {
        super(cipher);
        this.i = cipher;
        this.h = cipher.getBlockSize();
        if (this.h != 8) {
            throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
        }
        this.d = new byte[cipher.getBlockSize()];
        this.e = new byte[cipher.getBlockSize()];
        this.f = new byte[cipher.getBlockSize()];
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) throws IllegalArgumentException {
        this.a = true;
        this.b = 0;
        this.c = 0;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.d.length) {
                System.arraycopy(byArray, 0, this.d, this.d.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.d.length - byArray.length; ++i2) {
                    this.d[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.d, 0, this.d.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.i.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (params != null) {
                this.i.init(true, params);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.i.getAlgorithmName() + "/GCTR";
    }

    @Override
    public int getBlockSize() {
        return this.h;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.h, out, outOff);
        return this.h;
    }

    @Override
    public void reset() {
        this.a = true;
        this.b = 0;
        this.c = 0;
        System.arraycopy(this.d, 0, this.e, 0, this.d.length);
        this.g = 0;
        this.i.reset();
    }

    private int a(byte[] byArray, int n2) {
        return (byArray[n2 + 3] << 24 & 0xFF000000) + (byArray[n2 + 2] << 16 & 0xFF0000) + (byArray[n2 + 1] << 8 & 0xFF00) + (byArray[n2] & 0xFF);
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >>> 24);
        byArray[n3 + 2] = (byte)(n2 >>> 16);
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    @Override
    protected byte calculateByte(byte b2) {
        if (this.g == 0) {
            if (this.a) {
                this.a = false;
                this.i.processBlock(this.e, 0, this.f, 0);
                this.b = this.a(this.f, 0);
                this.c = this.a(this.f, 4);
            }
            this.b += 0x1010101;
            this.c += 0x1010104;
            if (this.c < 0x1010104 && this.c > 0) {
                ++this.c;
            }
            this.a(this.b, this.e, 0);
            this.a(this.c, this.e, 4);
            this.i.processBlock(this.e, 0, this.f, 0);
        }
        byte by = (byte)(this.f[this.g++] ^ b2);
        if (this.g == this.h) {
            this.g = 0;
            System.arraycopy(this.e, this.h, this.e, 0, this.e.length - this.h);
            System.arraycopy(this.f, 0, this.e, this.e.length - this.h, this.h);
        }
        return by;
    }
}

