/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.enterprisedt.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class Tables4kGCMMultiplier
implements GCMMultiplier {
    private byte[] a;
    private long[][] b;

    @Override
    public void init(byte[] H) {
        if (this.b == null) {
            this.b = new long[256][2];
        } else if (Arrays.areEqual(this.a, H)) {
            return;
        }
        this.a = Arrays.clone(H);
        GCMUtil.asLongs(this.a, this.b[1]);
        GCMUtil.multiplyP7(this.b[1], this.b[1]);
        for (int i2 = 2; i2 < 256; i2 += 2) {
            GCMUtil.divideP(this.b[i2 >> 1], this.b[i2]);
            GCMUtil.xor(this.b[i2], this.b[1], this.b[i2 + 1]);
        }
    }

    @Override
    public void multiplyH(byte[] x2) {
        long[] lArray = this.b[x2[15] & 0xFF];
        long l2 = lArray[0];
        long l3 = lArray[1];
        for (int i2 = 14; i2 >= 0; --i2) {
            lArray = this.b[x2[i2] & 0xFF];
            long l4 = l3 << 56;
            l3 = lArray[1] ^ (l3 >>> 8 | l2 << 56);
            l2 = lArray[0] ^ l2 >>> 8 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        }
        Pack.longToBigEndian(l2, x2, 0);
        Pack.longToBigEndian(l3, x2, 8);
    }
}

