/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.enterprisedt.bouncycastle.crypto.paddings.PKCS7Padding;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;

public class PaddedBufferedBlockCipher
extends BufferedBlockCipher {
    BlockCipherPadding a;

    public PaddedBufferedBlockCipher(BlockCipher cipher, BlockCipherPadding padding) {
        this.cipher = cipher;
        this.a = padding;
        this.buf = new byte[cipher.getBlockSize()];
        this.bufOff = 0;
    }

    public PaddedBufferedBlockCipher(BlockCipher cipher) {
        this(cipher, new PKCS7Padding());
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        this.reset();
        if (params instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)params;
            this.a.init(parametersWithRandom.getRandom());
            this.cipher.init(forEncryption, parametersWithRandom.getParameters());
        } else {
            this.a.init(null);
            this.cipher.init(forEncryption, params);
        }
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.bufOff;
        int n3 = n2 % this.buf.length;
        if (n3 == 0) {
            if (this.forEncryption) {
                return n2 + this.buf.length;
            }
            return n2;
        }
        return n2 - n3 + this.buf.length;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = len + this.bufOff;
        int n3 = n2 % this.buf.length;
        if (n3 == 0) {
            return Math.max(0, n2 - this.buf.length);
        }
        return n2 - n3;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
        return n2;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.getBlockSize();
        int n3 = this.getUpdateOutputSize(len);
        if (n3 > 0 && outOff + n3 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n4 = 0;
        int n5 = this.buf.length - this.bufOff;
        if (len > n5) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, n5);
            n4 += this.cipher.processBlock(this.buf, 0, out, outOff);
            this.bufOff = 0;
            len -= n5;
            inOff += n5;
            while (len > this.buf.length) {
                n4 += this.cipher.processBlock(in, inOff, out, outOff + n4);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        int n2 = this.cipher.getBlockSize();
        int n3 = 0;
        if (this.forEncryption) {
            if (this.bufOff == n2) {
                if (outOff + 2 * n2 > out.length) {
                    this.reset();
                    throw new OutputLengthException("output buffer too short");
                }
                n3 = this.cipher.processBlock(this.buf, 0, out, outOff);
                this.bufOff = 0;
            }
            this.a.addPadding(this.buf, this.bufOff);
            n3 += this.cipher.processBlock(this.buf, 0, out, outOff + n3);
            this.reset();
        } else {
            if (this.bufOff != n2) {
                this.reset();
                throw new DataLengthException("last block incomplete in decryption");
            }
            n3 = this.cipher.processBlock(this.buf, 0, this.buf, 0);
            this.bufOff = 0;
            try {
                System.arraycopy(this.buf, 0, out, outOff, n3 -= this.a.padCount(this.buf));
            }
            finally {
                this.reset();
            }
        }
        return n3;
    }
}

