/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class TBCPadding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "TBC";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int n2 = in.length - inOff;
        byte by = inOff > 0 ? (byte)((in[inOff - 1] & 1) == 0 ? 255 : 0) : (byte)((in[in.length - 1] & 1) == 0 ? 255 : 0);
        while (inOff < in.length) {
            in[inOff] = by;
            ++inOff;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2;
        byte by = in[in.length - 1];
        for (n2 = in.length - 1; n2 > 0 && in[n2 - 1] == by; --n2) {
        }
        return in.length - n2;
    }
}

