/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHMQVPublicParameters
implements CipherParameters {
    private DHPublicKeyParameters a;
    private DHPublicKeyParameters b;

    public DHMQVPublicParameters(DHPublicKeyParameters staticPublicKey, DHPublicKeyParameters ephemeralPublicKey) {
        if (staticPublicKey == null) {
            throw new NullPointerException("staticPublicKey cannot be null");
        }
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey cannot be null");
        }
        if (!staticPublicKey.getParameters().equals(ephemeralPublicKey.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral public keys have different domain parameters");
        }
        this.a = staticPublicKey;
        this.b = ephemeralPublicKey;
    }

    public DHPublicKeyParameters getStaticPublicKey() {
        return this.a;
    }

    public DHPublicKeyParameters getEphemeralPublicKey() {
        return this.b;
    }
}

