/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.DHKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import java.math.BigInteger;

public class DHPublicKeyParameters
extends DHKeyParameters {
    private static final BigInteger b = BigInteger.valueOf(1L);
    private static final BigInteger c = BigInteger.valueOf(2L);
    private BigInteger d;

    public DHPublicKeyParameters(BigInteger y2, DHParameters params) {
        super(false, params);
        this.d = this.a(y2, params);
    }

    private BigInteger a(BigInteger bigInteger, DHParameters dHParameters) {
        if (bigInteger == null) {
            throw new NullPointerException("y value cannot be null");
        }
        if (bigInteger.compareTo(c) < 0 || bigInteger.compareTo(dHParameters.getP().subtract(c)) > 0) {
            throw new IllegalArgumentException("invalid DH public key");
        }
        if (dHParameters.getQ() != null) {
            if (b.equals(bigInteger.modPow(dHParameters.getQ(), dHParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    public BigInteger getY() {
        return this.d;
    }

    @Override
    public int hashCode() {
        return this.d.hashCode() ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DHPublicKeyParameters)) {
            return false;
        }
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)obj;
        return dHPublicKeyParameters.getY().equals(this.d) && super.equals(obj);
    }
}

