/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;

public class ECDHUPrivateParameters
implements CipherParameters {
    private ECPrivateKeyParameters a;
    private ECPrivateKeyParameters b;
    private ECPublicKeyParameters c;

    public ECDHUPrivateParameters(ECPrivateKeyParameters staticPrivateKey, ECPrivateKeyParameters ephemeralPrivateKey) {
        this(staticPrivateKey, ephemeralPrivateKey, null);
    }

    public ECDHUPrivateParameters(ECPrivateKeyParameters staticPrivateKey, ECPrivateKeyParameters ephemeralPrivateKey, ECPublicKeyParameters ephemeralPublicKey) {
        if (staticPrivateKey == null) {
            throw new NullPointerException("staticPrivateKey cannot be null");
        }
        if (ephemeralPrivateKey == null) {
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        ECDomainParameters eCDomainParameters = staticPrivateKey.getParameters();
        if (!eCDomainParameters.equals(ephemeralPrivateKey.getParameters())) {
            throw new IllegalArgumentException("static and ephemeral private keys have different domain parameters");
        }
        if (ephemeralPublicKey == null) {
            ephemeralPublicKey = new ECPublicKeyParameters(eCDomainParameters.getG().multiply(ephemeralPrivateKey.getD()), eCDomainParameters);
        } else if (!eCDomainParameters.equals(ephemeralPublicKey.getParameters())) {
            throw new IllegalArgumentException("ephemeral public key has different domain parameters");
        }
        this.a = staticPrivateKey;
        this.b = ephemeralPrivateKey;
        this.c = ephemeralPublicKey;
    }

    public ECPrivateKeyParameters getStaticPrivateKey() {
        return this.a;
    }

    public ECPrivateKeyParameters getEphemeralPrivateKey() {
        return this.b;
    }

    public ECPublicKeyParameters getEphemeralPublicKey() {
        return this.c;
    }
}

