/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ECDomainParameters
implements ECConstants {
    private ECCurve a;
    private byte[] b;
    private ECPoint c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f = null;

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2) {
        this(curve, G, n2, ONE, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2, BigInteger h2) {
        this(curve, G, n2, h2, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2, BigInteger h2, byte[] seed) {
        if (curve == null) {
            throw new NullPointerException("curve");
        }
        if (n2 == null) {
            throw new NullPointerException("n");
        }
        this.a = curve;
        this.c = ECDomainParameters.a(curve, G);
        this.d = n2;
        this.e = h2;
        this.b = seed;
    }

    public ECCurve getCurve() {
        return this.a;
    }

    public ECPoint getG() {
        return this.c;
    }

    public BigInteger getN() {
        return this.d;
    }

    public BigInteger getH() {
        return this.e;
    }

    public synchronized BigInteger getHInv() {
        if (this.f == null) {
            this.f = this.e.modInverse(this.d);
        }
        return this.f;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ECDomainParameters) {
            ECDomainParameters eCDomainParameters = (ECDomainParameters)obj;
            return this.a.equals(eCDomainParameters.a) && this.c.equals(eCDomainParameters.c) && this.d.equals(eCDomainParameters.d) && this.e.equals(eCDomainParameters.e);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.a.hashCode();
        n2 *= 37;
        n2 ^= this.c.hashCode();
        n2 *= 37;
        n2 ^= this.d.hashCode();
        n2 *= 37;
        return n2 ^= this.e.hashCode();
    }

    static ECPoint a(ECCurve eCCurve, ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new IllegalArgumentException("point has null value");
        }
        if (eCPoint.isInfinity()) {
            throw new IllegalArgumentException("point at infinity");
        }
        if (!(eCPoint = eCPoint.normalize()).isValid()) {
            throw new IllegalArgumentException("point not on curve");
        }
        return ECAlgorithms.importPoint(eCCurve, eCPoint);
    }
}

