/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class HKDFParameters
implements DerivationParameters {
    private final byte[] a;
    private final boolean b;
    private final byte[] c;
    private final byte[] d;

    private HKDFParameters(byte[] ikm, boolean skip, byte[] salt, byte[] info) {
        if (ikm == null) {
            throw new IllegalArgumentException("IKM (input keying material) should not be null");
        }
        this.a = Arrays.clone(ikm);
        this.b = skip;
        this.c = (byte[])(salt == null || salt.length == 0 ? null : Arrays.clone(salt));
        this.d = info == null ? new byte[0] : Arrays.clone(info);
    }

    public HKDFParameters(byte[] ikm, byte[] salt, byte[] info) {
        this(ikm, false, salt, info);
    }

    public static HKDFParameters skipExtractParameters(byte[] ikm, byte[] info) {
        return new HKDFParameters(ikm, true, null, info);
    }

    public static HKDFParameters defaultParameters(byte[] ikm) {
        return new HKDFParameters(ikm, false, null, null);
    }

    public byte[] getIKM() {
        return Arrays.clone(this.a);
    }

    public boolean skipExtract() {
        return this.b;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.c);
    }

    public byte[] getInfo() {
        return Arrays.clone(this.d);
    }
}

