/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng.drbg;

import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.DualECPoints;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.a;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DualECSP800DRBG
implements SP80090DRBG {
    private static final BigInteger a = new BigInteger("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", 16);
    private static final BigInteger b = new BigInteger("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", 16);
    private static final BigInteger c = new BigInteger("c97445f45cdef9f0d3e05e1e585fc297235b82b5be8ff3efca67c59852018192", 16);
    private static final BigInteger d = new BigInteger("b28ef557ba31dfcbdd21ac46e2a91e3c304f44cb87058ada2cb815151e610046", 16);
    private static final BigInteger e = new BigInteger("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", 16);
    private static final BigInteger f = new BigInteger("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f", 16);
    private static final BigInteger g = new BigInteger("8e722de3125bddb05580164bfe20b8b432216a62926c57502ceede31c47816edd1e89769124179d0b695106428815065", 16);
    private static final BigInteger h = new BigInteger("023b1660dd701d0839fd45eec36f9ee7b32e13b315dc02610aa1b636e346df671f790f84c5e09b05674dbb7e45c803dd", 16);
    private static final BigInteger i = new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16);
    private static final BigInteger j = new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16);
    private static final BigInteger k = new BigInteger("1b9fa3e518d683c6b65763694ac8efbaec6fab44f2276171a42726507dd08add4c3b3f4c1ebc5b1222ddba077f722943b24c3edfa0f85fe24d0c8c01591f0be6f63", 16);
    private static final BigInteger l = new BigInteger("1f3bdba585295d9a1110d1df1f9430ef8442c5018976ff3437ef91b81dc0b8132c8d5c39c32d0e004a3092b7d327c0e7a4d26d2c7b69b58f9066652911e457779de", 16);
    private static final DualECPoints[] m = new DualECPoints[3];
    private Digest n;
    private long o;
    private EntropySource p;
    private int q;
    private int r;
    private int s;
    private ECPoint t;
    private ECPoint u;
    private byte[] v;
    private int w;
    private ECMultiplier x = new FixedPointCombMultiplier();

    public DualECSP800DRBG(Digest digest, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        this(m, digest, securityStrength, entropySource, personalizationString, nonce);
    }

    public DualECSP800DRBG(DualECPoints[] pointSet, Digest digest, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        this.n = digest;
        this.p = entropySource;
        this.q = securityStrength;
        if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(personalizationString, 512)) {
            throw new IllegalArgumentException("Personalization string too large");
        }
        if (entropySource.entropySize() < securityStrength || entropySource.entropySize() > 4096) {
            throw new IllegalArgumentException("EntropySource must provide between " + securityStrength + " and " + 4096 + " bits");
        }
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(byArray, nonce, personalizationString);
        for (int i2 = 0; i2 != pointSet.length; ++i2) {
            if (securityStrength > pointSet[i2].getSecurityStrength()) continue;
            if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(digest) < pointSet[i2].getSecurityStrength()) {
                throw new IllegalArgumentException("Requested security strength is not supported by digest");
            }
            this.r = pointSet[i2].getSeedLen();
            this.s = pointSet[i2].getMaxOutlen() / 8;
            this.t = pointSet[i2].getP();
            this.u = pointSet[i2].getQ();
            break;
        }
        if (this.t == null) {
            throw new IllegalArgumentException("security strength cannot be greater than 256 bits");
        }
        this.v = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.n, byArray2, this.r);
        this.w = this.v.length;
        this.o = 0L;
    }

    @Override
    public int getBlockSize() {
        return this.s * 8;
    }

    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        BigInteger bigInteger;
        int n2 = output.length * 8;
        int n3 = output.length / this.s;
        if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(additionalInput, 512)) {
            throw new IllegalArgumentException("Additional input too large");
        }
        if (this.o + (long)n3 > 0x80000000L) {
            return -1;
        }
        if (predictionResistant) {
            this.reseed(additionalInput);
            additionalInput = null;
        }
        if (additionalInput != null) {
            additionalInput = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.n, additionalInput, this.r);
            bigInteger = new BigInteger(1, this.a(this.v, additionalInput));
        } else {
            bigInteger = new BigInteger(1, this.v);
        }
        Arrays.fill(output, (byte)0);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte[] byArray = this.a(this.u, bigInteger = this.a(this.t, bigInteger)).toByteArray();
            if (byArray.length > this.s) {
                System.arraycopy(byArray, byArray.length - this.s, output, n4, this.s);
            } else {
                System.arraycopy(byArray, 0, output, n4 + (this.s - byArray.length), byArray.length);
            }
            n4 += this.s;
            ++this.o;
        }
        if (n4 < output.length) {
            bigInteger = this.a(this.t, bigInteger);
            byte[] byArray = this.a(this.u, bigInteger).toByteArray();
            int n5 = output.length - n4;
            if (byArray.length > this.s) {
                System.arraycopy(byArray, byArray.length - this.s, output, n4, n5);
            } else {
                System.arraycopy(byArray, 0, output, n4 + (this.s - byArray.length), n5);
            }
            ++this.o;
        }
        this.v = BigIntegers.asUnsignedByteArray(this.w, this.a(this.t, bigInteger));
        return n2;
    }

    @Override
    public void reseed(byte[] additionalInput) {
        if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(additionalInput, 512)) {
            throw new IllegalArgumentException("Additional input string too large");
        }
        byte[] byArray = this.a();
        byte[] byArray2 = Arrays.concatenate(this.a(this.v, this.r), byArray, additionalInput);
        this.v = com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(this.n, byArray2, this.r);
        this.o = 0L;
    }

    private byte[] a() {
        byte[] byArray = this.p.getEntropy();
        if (byArray.length < (this.q + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        return byArray3;
    }

    private byte[] a(byte[] byArray, int n2) {
        if (n2 % 8 == 0) {
            return byArray;
        }
        int n3 = 8 - n2 % 8;
        int n4 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            int n5 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n5 << n3 | n4 >> 8 - n3);
            n4 = n5;
        }
        return byArray;
    }

    private BigInteger a(ECPoint eCPoint, BigInteger bigInteger) {
        return this.x.multiply(eCPoint, bigInteger).normalize().getAffineXCoord().toBigInteger();
    }

    static {
        ECCurve.Fp fp = (ECCurve.Fp)NISTNamedCurves.getByName("P-256").getCurve();
        DualECSP800DRBG.m[0] = new DualECPoints(128, fp.createPoint(a, b), fp.createPoint(c, d), 1);
        fp = (ECCurve.Fp)NISTNamedCurves.getByName("P-384").getCurve();
        DualECSP800DRBG.m[1] = new DualECPoints(192, fp.createPoint(e, f), fp.createPoint(g, h), 1);
        fp = (ECCurve.Fp)NISTNamedCurves.getByName("P-521").getCurve();
        DualECSP800DRBG.m[2] = new DualECPoints(256, fp.createPoint(i, j), fp.createPoint(k, l), 1);
    }
}

