/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSA;
import com.enterprisedt.bouncycastle.crypto.params.DSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.DSAKCalculator;
import com.enterprisedt.bouncycastle.crypto.signers.RandomDSAKCalculator;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASigner
implements DSA {
    private final DSAKCalculator a;
    private DSAKeyParameters b;
    private SecureRandom c;

    public DSASigner() {
        this.a = new RandomDSAKCalculator();
    }

    public DSASigner(DSAKCalculator kCalculator) {
        this.a = kCalculator;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        SecureRandom secureRandom = null;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.b = (DSAPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.b = (DSAPrivateKeyParameters)param;
            }
        } else {
            this.b = (DSAPublicKeyParameters)param;
        }
        this.c = this.initSecureRandom(forSigning && !this.a.isDeterministic(), secureRandom);
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        DSAParameters dSAParameters = this.b.getParameters();
        BigInteger bigInteger = dSAParameters.getQ();
        BigInteger bigInteger2 = this.a(bigInteger, message);
        BigInteger bigInteger3 = ((DSAPrivateKeyParameters)this.b).getX();
        if (this.a.isDeterministic()) {
            this.a.init(bigInteger, bigInteger3, message);
        } else {
            this.a.init(bigInteger, this.c);
        }
        BigInteger bigInteger4 = this.a.nextK();
        BigInteger bigInteger5 = dSAParameters.getG().modPow(bigInteger4.add(this.a(bigInteger, this.c)), dSAParameters.getP()).mod(bigInteger);
        bigInteger4 = bigInteger4.modInverse(bigInteger).multiply(bigInteger2.add(bigInteger3.multiply(bigInteger5)));
        BigInteger bigInteger6 = bigInteger4.mod(bigInteger);
        return new BigInteger[]{bigInteger5, bigInteger6};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        DSAParameters dSAParameters = this.b.getParameters();
        BigInteger bigInteger = dSAParameters.getQ();
        BigInteger bigInteger2 = this.a(bigInteger, message);
        BigInteger bigInteger3 = BigInteger.valueOf(0L);
        if (bigInteger3.compareTo(r2) >= 0 || bigInteger.compareTo(r2) <= 0) {
            return false;
        }
        if (bigInteger3.compareTo(s2) >= 0 || bigInteger.compareTo(s2) <= 0) {
            return false;
        }
        BigInteger bigInteger4 = s2.modInverse(bigInteger);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger4).mod(bigInteger);
        BigInteger bigInteger6 = r2.multiply(bigInteger4).mod(bigInteger);
        BigInteger bigInteger7 = dSAParameters.getP();
        bigInteger5 = dSAParameters.getG().modPow(bigInteger5, bigInteger7);
        bigInteger6 = ((DSAPublicKeyParameters)this.b).getY().modPow(bigInteger6, bigInteger7);
        BigInteger bigInteger8 = bigInteger5.multiply(bigInteger6).mod(bigInteger7).mod(bigInteger);
        return bigInteger8.equals(r2);
    }

    private BigInteger a(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return !needed ? null : (provided != null ? provided : CryptoServicesRegistrar.getSecureRandom());
    }

    private BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        int n2 = 7;
        return new BigInteger(n2, secureRandom != null ? secureRandom : CryptoServicesRegistrar.getSecureRandom()).add(BigInteger.valueOf(128L)).multiply(bigInteger);
    }
}

