/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.enterprisedt.bouncycastle.crypto.engines.RSABlindedEngine;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class RSADigestSigner
implements Signer {
    private final AsymmetricBlockCipher a = new PKCS1Encoding(new RSABlindedEngine());
    private final AlgorithmIdentifier b;
    private final Digest c;
    private boolean d;
    private static final Hashtable e = new Hashtable();

    public RSADigestSigner(Digest digest) {
        this(digest, (ASN1ObjectIdentifier)e.get(digest.getAlgorithmName()));
    }

    public RSADigestSigner(Digest digest, ASN1ObjectIdentifier digestOid) {
        this.c = digest;
        this.b = new AlgorithmIdentifier(digestOid, DERNull.INSTANCE);
    }

    public String getAlgorithmName() {
        return this.c.getAlgorithmName() + "withRSA";
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.d = forSigning;
        AsymmetricKeyParameter asymmetricKeyParameter = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!forSigning && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.a.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.c.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.c.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.d) {
            throw new IllegalStateException("RSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.c.getDigestSize()];
        this.c.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.a(byArray);
            return this.a.processBlock(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        byte[] byArray;
        byte[] byArray2;
        if (this.d) {
            throw new IllegalStateException("RSADigestSigner not initialised for verification");
        }
        byte[] byArray3 = new byte[this.c.getDigestSize()];
        this.c.doFinal(byArray3, 0);
        try {
            byArray2 = this.a.processBlock(signature, 0, signature.length);
            byArray = this.a(byArray3);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray2.length == byArray.length) {
            return Arrays.constantTimeAreEqual(byArray2, byArray);
        }
        if (byArray2.length == byArray.length - 2) {
            int n2;
            int n3 = byArray2.length - byArray3.length - 2;
            int n4 = byArray.length - byArray3.length - 2;
            byArray[1] = (byte)(byArray[1] - 2);
            byArray[3] = (byte)(byArray[3] - 2);
            int n5 = 0;
            for (n2 = 0; n2 < byArray3.length; ++n2) {
                n5 |= byArray2[n3 + n2] ^ byArray[n4 + n2];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n5 |= byArray2[n2] ^ byArray[n2];
            }
            return n5 == 0;
        }
        Arrays.constantTimeAreEqual(byArray, byArray);
        return false;
    }

    @Override
    public void reset() {
        this.c.reset();
    }

    private byte[] a(byte[] byArray) throws IOException {
        DigestInfo digestInfo = new DigestInfo(this.b, byArray);
        return digestInfo.getEncoded("DER");
    }

    static {
        e.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        e.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        e.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        e.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        e.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        e.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        e.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        e.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        e.put("SHA-512/224", NISTObjectIdentifiers.id_sha512_224);
        e.put("SHA-512/256", NISTObjectIdentifiers.id_sha512_256);
        e.put("SHA3-224", NISTObjectIdentifiers.id_sha3_224);
        e.put("SHA3-256", NISTObjectIdentifiers.id_sha3_256);
        e.put("SHA3-384", NISTObjectIdentifiers.id_sha3_384);
        e.put("SHA3-512", NISTObjectIdentifiers.id_sha3_512);
        e.put("MD2", PKCSObjectIdentifiers.md2);
        e.put("MD4", PKCSObjectIdentifiers.md4);
        e.put("MD5", PKCSObjectIdentifiers.md5);
    }
}

