/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.enterprisedt.bouncycastle.crypto.macs.Poly1305;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipher;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public class Chacha20Poly1305
implements TlsCipher {
    private static final byte[] a = new byte[15];
    protected TlsContext context;
    protected ChaCha7539Engine encryptCipher;
    protected ChaCha7539Engine decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public Chacha20Poly1305(TlsContext context) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        int n2 = 32;
        int n3 = 12;
        int n4 = 2 * n2 + 2 * n3;
        byte[] byArray = TlsUtils.a(context, n4);
        int n5 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n5, n2);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n5 += n2, n2);
        byte[] byArray2 = Arrays.copyOfRange(byArray, n5 += n2, n5 + n3);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n5 += n3, n5 + n3);
        if ((n5 += n3) != n4) {
            throw new TlsFatalAlert(80);
        }
        this.encryptCipher = new ChaCha7539Engine();
        this.decryptCipher = new ChaCha7539Engine();
        if (context.isServer()) {
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
            this.encryptIV = byArray3;
            this.decryptIV = byArray2;
        } else {
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
            this.encryptIV = byArray2;
            this.decryptIV = byArray3;
        }
        this.encryptCipher.init(true, new ParametersWithIV(keyParameter2, this.encryptIV));
        this.decryptCipher.init(false, new ParametersWithIV(keyParameter, this.decryptIV));
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - 16;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        KeyParameter keyParameter = this.initRecord(this.encryptCipher, true, seqNo, this.encryptIV);
        byte[] byArray = new byte[len + 16];
        this.encryptCipher.processBytes(plaintext, offset, len, byArray, 0);
        byte[] byArray2 = this.getAdditionalData(seqNo, type, len);
        byte[] byArray3 = this.calculateRecordMAC(keyParameter, byArray2, byArray, 0, len);
        System.arraycopy(byArray3, 0, byArray, len, byArray3.length);
        return byArray;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] byArray;
        int n2;
        byte[] byArray2;
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        KeyParameter keyParameter = this.initRecord(this.decryptCipher, false, seqNo, this.decryptIV);
        byte[] byArray3 = this.calculateRecordMAC(keyParameter, byArray2 = this.getAdditionalData(seqNo, type, n2 = len - 16), ciphertext, offset, n2);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray = Arrays.copyOfRange(ciphertext, offset + n2, offset + len))) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray4 = new byte[n2];
        this.decryptCipher.processBytes(ciphertext, offset, n2, byArray4, 0);
        return byArray4;
    }

    protected KeyParameter initRecord(StreamCipher cipher, boolean forEncryption, long seqNo, byte[] iv) {
        byte[] byArray = this.calculateNonce(seqNo, iv);
        cipher.init(forEncryption, new ParametersWithIV(null, byArray));
        return this.generateRecordMACKey(cipher);
    }

    protected byte[] calculateNonce(long seqNo, byte[] iv) {
        byte[] byArray = new byte[12];
        TlsUtils.writeUint64(seqNo, byArray, 4);
        for (int i2 = 0; i2 < 12; ++i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ iv[i2]);
        }
        return byArray;
    }

    protected KeyParameter generateRecordMACKey(StreamCipher cipher) {
        byte[] byArray = new byte[64];
        cipher.processBytes(byArray, 0, byArray.length, byArray, 0);
        KeyParameter keyParameter = new KeyParameter(byArray, 0, 32);
        Arrays.fill(byArray, (byte)0);
        return keyParameter;
    }

    protected byte[] calculateRecordMAC(KeyParameter macKey, byte[] additionalData, byte[] buf, int off, int len) {
        Poly1305 poly1305 = new Poly1305();
        poly1305.init(macKey);
        this.updateRecordMACText(poly1305, additionalData, 0, additionalData.length);
        this.updateRecordMACText(poly1305, buf, off, len);
        this.updateRecordMACLength(poly1305, additionalData.length);
        this.updateRecordMACLength(poly1305, len);
        byte[] byArray = new byte[poly1305.getMacSize()];
        poly1305.doFinal(byArray, 0);
        return byArray;
    }

    protected void updateRecordMACLength(Mac mac, int len) {
        byte[] byArray = Pack.longToLittleEndian((long)len & 0xFFFFFFFFL);
        mac.update(byArray, 0, byArray.length);
    }

    protected void updateRecordMACText(Mac mac, byte[] buf, int off, int len) {
        mac.update(buf, off, len);
        int n2 = len % 16;
        if (n2 != 0) {
            mac.update(a, 0, 16 - n2);
        }
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(seqNo, byArray, 0);
        TlsUtils.writeUint8(type, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(len, byArray, 11);
        return byArray;
    }
}

