/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.f;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DTLSProtocol {
    protected final SecureRandom secureRandom;

    protected DTLSProtocol(SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException("'secureRandom' cannot be null");
        }
        this.secureRandom = secureRandom;
    }

    protected void processFinished(byte[] body, byte[] expected_verify_data) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        byte[] byArray = TlsUtils.readFully(expected_verify_data.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual(expected_verify_data, byArray)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(f recordLayer, short maxFragmentLength) throws IOException {
        if (maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + maxFragmentLength;
            recordLayer.a(n2);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean resumedSession, Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short s2 = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (s2 >= 0 && (!MaxFragmentLength.isValid(s2) || !resumedSession && s2 != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return s2;
    }

    protected static byte[] generateCertificate(Certificate certificate) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector supplementalData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, supplementalData);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void validateSelectedCipherSuite(int selectedCipherSuite, short alertDescription) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(selectedCipherSuite)) {
            case 1: 
            case 2: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
    }
}

