/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6StandardGroups;
import com.enterprisedt.bouncycastle.crypto.params.SRP6GroupParameters;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsSRPGroupVerifier
implements TlsSRPGroupVerifier {
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;

    public DefaultTlsSRPGroupVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPGroupVerifier(Vector groups) {
        this.groups = groups;
    }

    @Override
    public boolean accept(SRP6GroupParameters group) {
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (!this.areGroupsEqual(group, (SRP6GroupParameters)this.groups.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    protected boolean areGroupsEqual(SRP6GroupParameters a2, SRP6GroupParameters b2) {
        return a2 == b2 || this.areParametersEqual(a2.getN(), b2.getN()) && this.areParametersEqual(a2.getG(), b2.getG());
    }

    protected boolean areParametersEqual(BigInteger a2, BigInteger b2) {
        return a2 == b2 || a2.equals(b2);
    }

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }
}

