/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.enterprisedt.bouncycastle.crypto.tls.DefaultTlsSRPGroupVerifier;
import com.enterprisedt.bouncycastle.crypto.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipherFactory;
import com.enterprisedt.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSRPUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsClient
extends AbstractTlsClient {
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] identity, byte[] password) {
        this(new DefaultTlsCipherFactory(), new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, byte[] identity, byte[] password) {
        this(cipherFactory, new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, TlsSRPGroupVerifier groupVerifier, byte[] identity, byte[] password) {
        super(cipherFactory);
        this.groupVerifier = groupVerifier;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(serverExtensions);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.groupVerifier, this.identity, this.password);
    }
}

