/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class SessionParameters {
    private int a;
    private short b;
    private byte[] c;
    private Certificate d;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g;

    private SessionParameters(int cipherSuite, short compressionAlgorithm, byte[] masterSecret, Certificate peerCertificate, byte[] pskIdentity, byte[] srpIdentity, byte[] encodedServerExtensions) {
        this.a = cipherSuite;
        this.b = compressionAlgorithm;
        this.c = Arrays.clone(masterSecret);
        this.d = peerCertificate;
        this.e = Arrays.clone(pskIdentity);
        this.f = Arrays.clone(srpIdentity);
        this.g = encodedServerExtensions;
    }

    public void clear() {
        if (this.c != null) {
            Arrays.fill(this.c, (byte)0);
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
    }

    public int getCipherSuite() {
        return this.a;
    }

    public short getCompressionAlgorithm() {
        return this.b;
    }

    public byte[] getMasterSecret() {
        return this.c;
    }

    public Certificate getPeerCertificate() {
        return this.d;
    }

    public byte[] getPskIdentity() {
        return this.e;
    }

    public byte[] getPSKIdentity() {
        return this.e;
    }

    public byte[] getSRPIdentity() {
        return this.f;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.g == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.g);
        return TlsProtocol.readExtensions(byteArrayInputStream);
    }

    public static final class Builder {
        private int a = -1;
        private short b = (short)-1;
        private byte[] c = null;
        private Certificate d = null;
        private byte[] e = null;
        private byte[] f = null;
        private byte[] g = null;

        public SessionParameters build() {
            this.a(this.a >= 0, "cipherSuite");
            this.a(this.b >= 0, "compressionAlgorithm");
            this.a(this.c != null, "masterSecret");
            return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        public Builder setCipherSuite(int cipherSuite) {
            this.a = cipherSuite;
            return this;
        }

        public Builder setCompressionAlgorithm(short compressionAlgorithm) {
            this.b = compressionAlgorithm;
            return this;
        }

        public Builder setMasterSecret(byte[] masterSecret) {
            this.c = masterSecret;
            return this;
        }

        public Builder setPeerCertificate(Certificate peerCertificate) {
            this.d = peerCertificate;
            return this;
        }

        public Builder setPskIdentity(byte[] pskIdentity) {
            this.e = pskIdentity;
            return this;
        }

        public Builder setPSKIdentity(byte[] pskIdentity) {
            this.e = pskIdentity;
            return this;
        }

        public Builder setSRPIdentity(byte[] srpIdentity) {
            this.f = srpIdentity;
            return this;
        }

        public Builder setServerExtensions(Hashtable serverExtensions) throws IOException {
            if (serverExtensions == null) {
                this.g = null;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(byteArrayOutputStream, serverExtensions);
                this.g = byteArrayOutputStream.toByteArray();
            }
            return this;
        }

        private void a(boolean bl, String string) {
            if (!bl) {
                throw new IllegalStateException("Required session parameter '" + string + "' not configured");
            }
        }
    }
}

