/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.crypto.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.crypto.tls.ServerDHParams;
import com.enterprisedt.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.j;
import com.enterprisedt.bouncycastle.crypto.tls.l;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms, dhParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        j j2 = new j();
        this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, j2);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest digest = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.g, 0, securityParameters.g.length);
        digest.update(securityParameters.h, 0, securityParameters.h.length);
        j2.a(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode(j2);
        return j2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        l l2 = new l();
        TeeInputStream teeInputStream = new TeeInputStream(input, l2);
        ServerDHParams serverDHParams = ServerDHParams.parse(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(input);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        l2.a(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreePublicKey = TlsDHUtils.validateDHPublicKey(serverDHParams.getPublicKey());
        this.dhParameters = this.validateDHParameters(this.dhAgreePublicKey.getParameters());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.g, 0, securityParameters.g.length);
        signer.update(securityParameters.h, 0, securityParameters.h.length);
        return signer;
    }
}

