/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.tls.ECBasisType;
import com.enterprisedt.bouncycastle.crypto.tls.NamedCurve;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.field.PolynomialExtensionField;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;

public class TlsECCUtils {
    public static final Integer EXT_elliptic_curves = Integers.valueOf(10);
    public static final Integer EXT_ec_point_formats = Integers.valueOf(11);
    private static final String[] a = new String[]{"sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1", "brainpoolP256r1", "brainpoolP384r1", "brainpoolP512r1"};

    public static void addSupportedEllipticCurvesExtension(Hashtable extensions, int[] namedCurves) throws IOException {
        extensions.put(EXT_elliptic_curves, TlsECCUtils.createSupportedEllipticCurvesExtension(namedCurves));
    }

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static int[] getSupportedEllipticCurvesExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_elliptic_curves);
        return byArray == null ? null : TlsECCUtils.readSupportedEllipticCurvesExtension(byArray);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_ec_point_formats);
        return byArray == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static byte[] createSupportedEllipticCurvesExtension(int[] namedCurves) throws IOException {
        if (namedCurves == null || namedCurves.length < 1) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(namedCurves);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null || !Arrays.contains(ecPointFormats, (short)0)) {
            ecPointFormats = Arrays.append(ecPointFormats, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(ecPointFormats);
    }

    public static int[] readSupportedEllipticCurvesExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.contains(sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static String getNameOfNamedCurve(int namedCurve) {
        return TlsECCUtils.isSupportedNamedCurve(namedCurve) ? a[namedCurve - 1] : null;
    }

    public static ECDomainParameters getParametersForNamedCurve(int namedCurve) {
        String string = TlsECCUtils.getNameOfNamedCurve(namedCurve);
        if (string == null) {
            return null;
        }
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName(string)) == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public static boolean hasAnySupportedNamedCurves() {
        return a.length > 0;
    }

    public static boolean containsECCCipherSuites(int[] cipherSuites) {
        for (int i2 = 0; i2 < cipherSuites.length; ++i2) {
            if (!TlsECCUtils.isECCCipherSuite(cipherSuites[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean isECCCipherSuite(int cipherSuite) {
        switch (cipherSuite) {
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49306: 
            case 49307: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52396: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65300: 
            case 65301: {
                return true;
            }
        }
        return false;
    }

    public static boolean areOnSameCurve(ECDomainParameters a2, ECDomainParameters b2) {
        return a2 != null && a2.equals(b2);
    }

    public static boolean isSupportedNamedCurve(int namedCurve) {
        return namedCurve > 0 && namedCurve <= a.length;
    }

    public static boolean isCompressionPreferred(short[] ecPointFormats, short compressionFormat) {
        if (ecPointFormats == null) {
            return false;
        }
        for (int i2 = 0; i2 < ecPointFormats.length; ++i2) {
            short s2 = ecPointFormats[i2];
            if (s2 == 0) {
                return false;
            }
            if (s2 != compressionFormat) continue;
            return true;
        }
        return false;
    }

    public static byte[] serializeECFieldElement(int fieldSize, BigInteger x2) throws IOException {
        return BigIntegers.asUnsignedByteArray((fieldSize + 7) / 8, x2);
    }

    public static byte[] serializeECPoint(short[] ecPointFormats, ECPoint point) throws IOException {
        ECCurve eCCurve = point.getCurve();
        boolean bl = false;
        if (ECAlgorithms.isFpCurve(eCCurve)) {
            bl = TlsECCUtils.isCompressionPreferred(ecPointFormats, (short)1);
        } else if (ECAlgorithms.isF2mCurve(eCCurve)) {
            bl = TlsECCUtils.isCompressionPreferred(ecPointFormats, (short)2);
        }
        return point.getEncoded(bl);
    }

    public static byte[] serializeECPublicKey(short[] ecPointFormats, ECPublicKeyParameters keyParameters) throws IOException {
        return TlsECCUtils.serializeECPoint(ecPointFormats, keyParameters.getQ());
    }

    public static BigInteger deserializeECFieldElement(int fieldSize, byte[] encoding) throws IOException {
        int n2 = (fieldSize + 7) / 8;
        if (encoding.length != n2) {
            throw new TlsFatalAlert(50);
        }
        return new BigInteger(1, encoding);
    }

    public static ECPoint deserializeECPoint(short[] ecPointFormats, ECCurve curve, byte[] encoding) throws IOException {
        short s2;
        if (encoding == null || encoding.length < 1) {
            throw new TlsFatalAlert(47);
        }
        switch (encoding[0]) {
            case 2: 
            case 3: {
                if (ECAlgorithms.isF2mCurve(curve)) {
                    s2 = 2;
                    break;
                }
                if (ECAlgorithms.isFpCurve(curve)) {
                    s2 = 1;
                    break;
                }
                throw new TlsFatalAlert(47);
            }
            case 4: {
                s2 = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(47);
            }
        }
        if (!(s2 == 0 || ecPointFormats != null && Arrays.contains(ecPointFormats, s2))) {
            throw new TlsFatalAlert(47);
        }
        return curve.decodePoint(encoding);
    }

    public static ECPublicKeyParameters deserializeECPublicKey(short[] ecPointFormats, ECDomainParameters curve_params, byte[] encoding) throws IOException {
        try {
            ECPoint eCPoint = TlsECCUtils.deserializeECPoint(ecPointFormats, curve_params.getCurve(), encoding);
            return new ECPublicKeyParameters(eCPoint, curve_params);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public static byte[] calculateECDHBasicAgreement(ECPublicKeyParameters publicKey, ECPrivateKeyParameters privateKey) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init(privateKey);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), bigInteger);
    }

    public static AsymmetricCipherKeyPair generateECKeyPair(SecureRandom random, ECDomainParameters ecParams) {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(ecParams, random));
        return eCKeyPairGenerator.generateKeyPair();
    }

    public static ECPrivateKeyParameters generateEphemeralClientKeyExchange(SecureRandom random, short[] ecPointFormats, ECDomainParameters ecParams, OutputStream output) throws IOException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsECCUtils.generateECKeyPair(random, ecParams);
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        TlsECCUtils.writeECPoint(ecPointFormats, eCPublicKeyParameters.getQ(), output);
        return (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
    }

    static ECPrivateKeyParameters a(SecureRandom secureRandom, int[] nArray, short[] sArray, OutputStream outputStream) throws IOException {
        int n2 = -1;
        if (nArray == null) {
            n2 = 23;
        } else {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n3 = nArray[i2];
                if (!NamedCurve.isValid(n3) || !TlsECCUtils.isSupportedNamedCurve(n3)) continue;
                n2 = n3;
                break;
            }
        }
        ECDomainParameters eCDomainParameters = null;
        if (n2 >= 0) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(n2);
        } else if (Arrays.contains(nArray, 65281)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (Arrays.contains(nArray, 65282)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(10);
        }
        if (eCDomainParameters == null) {
            throw new TlsFatalAlert(80);
        }
        if (n2 < 0) {
            TlsECCUtils.writeExplicitECParameters(sArray, eCDomainParameters, outputStream);
        } else {
            TlsECCUtils.writeNamedECParameters(n2, outputStream);
        }
        return TlsECCUtils.generateEphemeralClientKeyExchange(secureRandom, sArray, eCDomainParameters, outputStream);
    }

    public static ECPublicKeyParameters validateECPublicKey(ECPublicKeyParameters key) throws IOException {
        return key;
    }

    public static int readECExponent(int fieldSize, InputStream input) throws IOException {
        int n2;
        BigInteger bigInteger = TlsECCUtils.readECParameter(input);
        if (bigInteger.bitLength() < 32 && (n2 = bigInteger.intValue()) > 0 && n2 < fieldSize) {
            return n2;
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readECFieldElement(int fieldSize, InputStream input) throws IOException {
        return TlsECCUtils.deserializeECFieldElement(fieldSize, TlsUtils.readOpaque8(input));
    }

    public static BigInteger readECParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque8(input));
    }

    public static ECDomainParameters readECParameters(int[] namedCurves, short[] ecPointFormats, InputStream input) throws IOException {
        try {
            short s2 = TlsUtils.readUint8(input);
            switch (s2) {
                case 1: {
                    TlsECCUtils.a(namedCurves, 65281);
                    BigInteger bigInteger = TlsECCUtils.readECParameter(input);
                    BigInteger bigInteger2 = TlsECCUtils.readECFieldElement(bigInteger.bitLength(), input);
                    BigInteger bigInteger3 = TlsECCUtils.readECFieldElement(bigInteger.bitLength(), input);
                    byte[] byArray = TlsUtils.readOpaque8(input);
                    BigInteger bigInteger4 = TlsECCUtils.readECParameter(input);
                    BigInteger bigInteger5 = TlsECCUtils.readECParameter(input);
                    ECCurve.Fp fp = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
                    ECPoint eCPoint = TlsECCUtils.deserializeECPoint(ecPointFormats, fp, byArray);
                    return new ECDomainParameters(fp, eCPoint, bigInteger4, bigInteger5);
                }
                case 2: {
                    TlsECCUtils.a(namedCurves, 65282);
                    int n2 = TlsUtils.readUint16(input);
                    short s3 = TlsUtils.readUint8(input);
                    if (!ECBasisType.isValid(s3)) {
                        throw new TlsFatalAlert(47);
                    }
                    int n3 = TlsECCUtils.readECExponent(n2, input);
                    int n4 = -1;
                    int n5 = -1;
                    if (s3 == 2) {
                        n4 = TlsECCUtils.readECExponent(n2, input);
                        n5 = TlsECCUtils.readECExponent(n2, input);
                    }
                    BigInteger bigInteger = TlsECCUtils.readECFieldElement(n2, input);
                    BigInteger bigInteger6 = TlsECCUtils.readECFieldElement(n2, input);
                    byte[] byArray = TlsUtils.readOpaque8(input);
                    BigInteger bigInteger7 = TlsECCUtils.readECParameter(input);
                    BigInteger bigInteger8 = TlsECCUtils.readECParameter(input);
                    ECCurve.F2m f2m = s3 == 2 ? new ECCurve.F2m(n2, n3, n4, n5, bigInteger, bigInteger6, bigInteger7, bigInteger8) : new ECCurve.F2m(n2, n3, bigInteger, bigInteger6, bigInteger7, bigInteger8);
                    ECPoint eCPoint = TlsECCUtils.deserializeECPoint(ecPointFormats, f2m, byArray);
                    return new ECDomainParameters(f2m, eCPoint, bigInteger7, bigInteger8);
                }
                case 3: {
                    int n6 = TlsUtils.readUint16(input);
                    if (!NamedCurve.refersToASpecificNamedCurve(n6)) {
                        throw new TlsFatalAlert(47);
                    }
                    TlsECCUtils.a(namedCurves, n6);
                    return TlsECCUtils.getParametersForNamedCurve(n6);
                }
            }
            throw new TlsFatalAlert(47);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    private static void a(int[] nArray, int n2) throws IOException {
        if (nArray != null && !Arrays.contains(nArray, n2)) {
            throw new TlsFatalAlert(47);
        }
    }

    public static void writeECExponent(int k2, OutputStream output) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(k2);
        TlsECCUtils.writeECParameter(bigInteger, output);
    }

    public static void writeECFieldElement(ECFieldElement x2, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(x2.getEncoded(), output);
    }

    public static void writeECFieldElement(int fieldSize, BigInteger x2, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECFieldElement(fieldSize, x2), output);
    }

    public static void writeECParameter(BigInteger x2, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(BigIntegers.asUnsignedByteArray(x2), output);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeExplicitECParameters(short[] ecPointFormats, ECDomainParameters ecParameters, OutputStream output) throws IOException {
        ECCurve eCCurve = ecParameters.getCurve();
        if (ECAlgorithms.isFpCurve(eCCurve)) {
            TlsUtils.writeUint8((short)1, output);
            TlsECCUtils.writeECParameter(eCCurve.getField().getCharacteristic(), output);
        } else {
            if (!ECAlgorithms.isF2mCurve(eCCurve)) throw new IllegalArgumentException("'ecParameters' not a known curve type");
            PolynomialExtensionField polynomialExtensionField = (PolynomialExtensionField)eCCurve.getField();
            int[] nArray = polynomialExtensionField.getMinimalPolynomial().getExponentsPresent();
            TlsUtils.writeUint8((short)2, output);
            int n2 = nArray[nArray.length - 1];
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, output);
            if (nArray.length == 3) {
                TlsUtils.writeUint8((short)1, output);
                TlsECCUtils.writeECExponent(nArray[1], output);
            } else {
                if (nArray.length != 5) throw new IllegalArgumentException("Only trinomial and pentomial curves are supported");
                TlsUtils.writeUint8((short)2, output);
                TlsECCUtils.writeECExponent(nArray[1], output);
                TlsECCUtils.writeECExponent(nArray[2], output);
                TlsECCUtils.writeECExponent(nArray[3], output);
            }
        }
        TlsECCUtils.writeECFieldElement(eCCurve.getA(), output);
        TlsECCUtils.writeECFieldElement(eCCurve.getB(), output);
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECPoint(ecPointFormats, ecParameters.getG()), output);
        TlsECCUtils.writeECParameter(ecParameters.getN(), output);
        TlsECCUtils.writeECParameter(ecParameters.getH(), output);
    }

    public static void writeECPoint(short[] ecPointFormats, ECPoint point, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECPoint(ecPointFormats, point), output);
    }

    public static void writeNamedECParameters(int namedCurve, OutputStream output) throws IOException {
        if (!NamedCurve.refersToASpecificNamedCurve(namedCurve)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedCurve);
        TlsUtils.writeUint16(namedCurve, output);
    }
}

