/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.crypto.tls.TlsAgreementCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsECDSASigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsRSASigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSigner;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected AsymmetricKeyParameter serverPublicKey;
    protected TlsAgreementCredentials agreementCredentials;
    protected ECPrivateKeyParameters ecAgreePrivateKey;
    protected ECPublicKeyParameters ecAgreePublicKey;

    public TlsECDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 19: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 17: {
                this.tlsSigner = new TlsECDSASigner();
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                this.tlsSigner = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.namedCurves = namedCurves;
        this.clientECPointFormats = clientECPointFormats;
        this.serverECPointFormats = serverECPointFormats;
    }

    @Override
    public void init(TlsContext context) {
        super.init(context);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(context);
        }
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 20) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        com.enterprisedt.bouncycastle.asn1.x509.Certificate certificate = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
        if (this.tlsSigner == null) {
            try {
                this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey((ECPublicKeyParameters)this.serverPublicKey);
            }
            catch (ClassCastException classCastException) {
                throw new TlsFatalAlert(46, (Throwable)classCastException);
            }
            TlsUtils.a(certificate, 8);
        } else {
            if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.a(certificate, 128);
        }
        super.processServerCertificate(serverCertificate);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 17: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.ecAgreePrivateKey = TlsECCUtils.a(this.context.getSecureRandom(), this.namedCurves, this.clientECPointFormats, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
        ECDomainParameters eCDomainParameters = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, input);
        byte[] byArray = TlsUtils.readOpaque8(input);
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, eCDomainParameters, byArray));
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(40);
        }
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i2 = 0; i2 < sArray.length; ++i2) {
            switch (sArray[i2]) {
                case 1: 
                case 2: 
                case 64: 
                case 65: 
                case 66: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(80);
        }
        if (clientCredentials instanceof TlsAgreementCredentials) {
            this.agreementCredentials = (TlsAgreementCredentials)clientCredentials;
        } else if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.agreementCredentials == null) {
            this.ecAgreePrivateKey = TlsECCUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.serverECPointFormats, this.ecAgreePublicKey.getParameters(), output);
        }
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        if (this.ecAgreePublicKey != null) {
            return;
        }
        byte[] byArray = TlsUtils.readOpaque8(input);
        ECDomainParameters eCDomainParameters = this.ecAgreePrivateKey.getParameters();
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.serverECPointFormats, eCDomainParameters, byArray));
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.ecAgreePublicKey);
        }
        if (this.ecAgreePrivateKey != null) {
            return TlsECCUtils.calculateECDHBasicAgreement(this.ecAgreePublicKey, this.ecAgreePrivateKey);
        }
        throw new TlsFatalAlert(80);
    }
}

