/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.digests.LongDigest;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.SSL3Mac;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsMac(TlsContext context, Digest digest, byte[] key, int keyOff, int keyLen) {
        this.context = context;
        KeyParameter keyParameter = new KeyParameter(key, keyOff, keyLen);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (TlsUtils.isSSL(context)) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
        this.macLength = this.mac.getMacSize();
        if (context.getSecurityParameters().m) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.macLength;
    }

    public byte[] calculateMac(long seqNo, short type, byte[] message, int offset, int length) {
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        boolean bl = protocolVersion.isSSL();
        byte[] byArray = new byte[bl ? 11 : 13];
        TlsUtils.writeUint64(seqNo, byArray, 0);
        TlsUtils.writeUint8(type, byArray, 8);
        if (!bl) {
            TlsUtils.writeVersion(protocolVersion, byArray, 9);
        }
        TlsUtils.writeUint16(length, byArray, byArray.length - 2);
        this.mac.update(byArray, 0, byArray.length);
        this.mac.update(message, offset, length);
        byte[] byArray2 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray2, 0);
        return this.truncate(byArray2);
    }

    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] message, int offset, int length, int fullLength, byte[] dummyData) {
        byte[] byArray = this.calculateMac(seqNo, type, message, offset, length);
        int n2 = TlsUtils.isSSL(this.context) ? 11 : 13;
        int n3 = this.getDigestBlockCount(n2 + fullLength) - this.getDigestBlockCount(n2 + length);
        while (--n3 >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData[0]);
        this.mac.reset();
        return byArray;
    }

    protected int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] bs) {
        if (bs.length <= this.macLength) {
            return bs;
        }
        return Arrays.copyOf(bs, this.macLength);
    }
}

