/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipher;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsMac;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsNullCipher
implements TlsCipher {
    protected TlsContext context;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsNullCipher(TlsContext context) {
        this.context = context;
        this.writeMac = null;
        this.readMac = null;
    }

    public TlsNullCipher(TlsContext context, Digest clientWriteDigest, Digest serverWriteDigest) throws IOException {
        if (clientWriteDigest == null != (serverWriteDigest == null)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        TlsMac tlsMac = null;
        TlsMac tlsMac2 = null;
        if (clientWriteDigest != null) {
            int n2 = clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
            byte[] byArray = TlsUtils.a(context, n2);
            int n3 = 0;
            tlsMac = new TlsMac(context, clientWriteDigest, byArray, n3, clientWriteDigest.getDigestSize());
            tlsMac2 = new TlsMac(context, serverWriteDigest, byArray, n3 += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
            if ((n3 += serverWriteDigest.getDigestSize()) != n2) {
                throw new TlsFatalAlert(80);
            }
        }
        if (context.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
        }
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        int n2 = ciphertextLimit;
        if (this.writeMac != null) {
            n2 -= this.writeMac.getSize();
        }
        return n2;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        if (this.writeMac == null) {
            return Arrays.copyOfRange(plaintext, offset, offset + len);
        }
        byte[] byArray = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        byte[] byArray2 = new byte[len + byArray.length];
        System.arraycopy(plaintext, offset, byArray2, 0, len);
        System.arraycopy(byArray, 0, byArray2, len, byArray.length);
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] byArray;
        if (this.readMac == null) {
            return Arrays.copyOfRange(ciphertext, offset, offset + len);
        }
        int n2 = this.readMac.getSize();
        if (len < n2) {
            throw new TlsFatalAlert(50);
        }
        int n3 = len - n2;
        byte[] byArray2 = Arrays.copyOfRange(ciphertext, offset + n3, offset + len);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray = this.readMac.calculateMac(seqNo, type, ciphertext, offset, n3))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + n3);
    }
}

