/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.prng.RandomGenerator;
import com.enterprisedt.bouncycastle.crypto.tls.ByteQueue;
import com.enterprisedt.bouncycastle.crypto.tls.ByteQueueInputStream;
import com.enterprisedt.bouncycastle.crypto.tls.ByteQueueOutputStream;
import com.enterprisedt.bouncycastle.crypto.tls.Certificate;
import com.enterprisedt.bouncycastle.crypto.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SessionParameters;
import com.enterprisedt.bouncycastle.crypto.tls.SupplementalDataEntry;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlertReceived;
import com.enterprisedt.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.crypto.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.crypto.tls.TlsNoCloseNotifyException;
import com.enterprisedt.bouncycastle.crypto.tls.TlsPeer;
import com.enterprisedt.bouncycastle.crypto.tls.TlsSession;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.crypto.tls.k;
import com.enterprisedt.bouncycastle.crypto.tls.n;
import com.enterprisedt.bouncycastle.crypto.tls.o;
import com.enterprisedt.bouncycastle.crypto.tls.q;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_CERTIFICATE_STATUS = 5;
    protected static final short CS_SERVER_KEY_EXCHANGE = 6;
    protected static final short CS_CERTIFICATE_REQUEST = 7;
    protected static final short CS_SERVER_HELLO_DONE = 8;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 9;
    protected static final short CS_CLIENT_CERTIFICATE = 10;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 11;
    protected static final short CS_CERTIFICATE_VERIFY = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_FINISHED = 15;
    protected static final short CS_END = 16;
    protected static final short ADS_MODE_1_Nsub1 = 0;
    protected static final short ADS_MODE_0_N = 1;
    protected static final short ADS_MODE_0_N_FIRSTONLY = 2;
    private ByteQueue a = new ByteQueue(0);
    private ByteQueue c = new ByteQueue(2);
    private ByteQueue d = new ByteQueue(0);
    k b;
    protected SecureRandom secureRandom;
    private n e = null;
    private o f = null;
    private volatile boolean g = false;
    private volatile boolean h = false;
    private volatile boolean i = false;
    private volatile boolean j = true;
    private volatile int k = 0;
    private byte[] l = null;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected SecurityParameters securityParameters = null;
    protected Certificate peerCertificate = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean resumedSession = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean secure_renegotiation = false;
    protected boolean allowCertificateStatus = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    public TlsProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        this.blocking = true;
        this.b = new k(this, input, output);
        this.secureRandom = secureRandom;
    }

    public TlsProtocol(SecureRandom secureRandom) {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.b = new k(this, this.inputBuffers, this.outputBuffer);
        this.secureRandom = secureRandom;
    }

    protected abstract TlsContext getContext();

    abstract com.enterprisedt.bouncycastle.crypto.tls.a a();

    protected abstract TlsPeer getPeer();

    protected void handleAlertMessage(short alertLevel, short alertDescription) throws IOException {
        this.getPeer().notifyAlertReceived(alertLevel, alertDescription);
        if (alertLevel != 1) {
            this.handleFailure();
            throw new TlsFatalAlertReceived(alertDescription);
        }
        this.handleAlertWarningMessage(alertDescription);
    }

    protected void handleAlertWarningMessage(short alertDescription) throws IOException {
        if (alertDescription == 0) {
            if (!this.i) {
                throw new TlsFatalAlert(40);
            }
            this.handleClose(false);
        }
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.g) {
            this.g = true;
            if (user_canceled && !this.i) {
                this.raiseAlertWarning((short)90, "User canceled handshake");
            }
            this.raiseAlertWarning((short)0, "Connection closed");
            this.b.k();
            if (!this.i) {
                this.cleanupHandshake();
            }
        }
    }

    protected void handleException(short alertDescription, String message, Throwable cause) throws IOException {
        if (!this.g) {
            this.raiseAlertFatal(alertDescription, message, cause);
            this.handleFailure();
        }
    }

    protected void handleFailure() {
        this.g = true;
        this.h = true;
        this.invalidateSession();
        this.b.k();
        if (!this.i) {
            this.cleanupHandshake();
        }
    }

    protected abstract void handleHandshakeMessage(short var1, ByteArrayInputStream var2) throws IOException;

    protected void applyMaxFragmentLengthExtension() throws IOException {
        if (this.securityParameters.l >= 0) {
            if (!MaxFragmentLength.isValid(this.securityParameters.l)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + this.securityParameters.l;
            this.b.a(n2);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean expected) throws IOException {
        if (expected != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void cleanupHandshake() {
        if (this.l != null) {
            Arrays.fill(this.l, (byte)0);
            this.l = null;
        }
        this.securityParameters.a();
        this.peerCertificate = null;
        this.offeredCipherSuites = null;
        this.offeredCompressionMethods = null;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.resumedSession = false;
        this.receivedChangeCipherSpec = false;
        this.secure_renegotiation = false;
        this.allowCertificateStatus = false;
        this.expectSessionTicket = false;
    }

    protected void blockForHandshake() throws IOException {
        if (this.blocking) {
            while (this.connection_state != 16) {
                if (this.g) {
                    throw new TlsFatalAlert(80);
                }
                this.safeReadRecord();
            }
        }
    }

    protected void completeHandshake() throws IOException {
        try {
            this.connection_state = (short)16;
            this.c.shrink();
            this.d.shrink();
            this.b.e();
            boolean bl = this.j = !TlsUtils.isTLSv11(this.getContext());
            if (!this.i) {
                this.i = true;
                if (this.blocking) {
                    this.e = new n(this);
                    this.f = new o(this);
                }
            }
            if (this.tlsSession != null) {
                if (this.sessionParameters == null) {
                    this.sessionParameters = new SessionParameters.Builder().setCipherSuite(this.securityParameters.getCipherSuite()).setCompressionAlgorithm(this.securityParameters.getCompressionAlgorithm()).setMasterSecret(this.securityParameters.getMasterSecret()).setPeerCertificate(this.peerCertificate).setPSKIdentity(this.securityParameters.getPSKIdentity()).setSRPIdentity(this.securityParameters.getSRPIdentity()).setServerExtensions(this.serverExtensions).build();
                    this.tlsSession = new q(this.tlsSession.getSessionID(), this.sessionParameters);
                }
                this.a().a(this.tlsSession);
            }
            this.getPeer().notifyHandshakeComplete();
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short protocol, byte[] buf, int off, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.c.addData(buf, off, len);
                this.c();
                break;
            }
            case 23: {
                if (!this.i) {
                    throw new TlsFatalAlert(10);
                }
                this.a.addData(buf, off, len);
                this.b();
                break;
            }
            case 20: {
                this.a(buf, off, len);
                break;
            }
            case 22: {
                if (this.d.available() > 0) {
                    this.d.addData(buf, off, len);
                    this.a(this.d);
                    break;
                }
                ByteQueue byteQueue = new ByteQueue(buf, off, len);
                this.a(byteQueue);
                int n2 = byteQueue.available();
                if (n2 <= 0) break;
                this.d.addData(buf, off + len - n2, n2);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    private void a(ByteQueue byteQueue) throws IOException {
        while (byteQueue.available() >= 4) {
            Object object;
            byte[] byArray = new byte[4];
            byteQueue.read(byArray, 0, 4, 0);
            short s2 = TlsUtils.readUint8(byArray, 0);
            int n2 = TlsUtils.readUint24(byArray, 1);
            int n3 = 4 + n2;
            if (byteQueue.available() < n3) break;
            this.checkReceivedChangeCipherSpec(this.connection_state == 16 || s2 == 20);
            switch (s2) {
                case 0: {
                    break;
                }
                case 20: {
                    object = this.getContext();
                    if (this.l == null && object.getSecurityParameters().getMasterSecret() != null) {
                        this.l = this.createVerifyData(!object.isServer());
                    }
                }
                default: {
                    byteQueue.copyTo(this.b.i(), n3);
                }
            }
            byteQueue.removeData(4);
            object = byteQueue.readFrom(n2);
            this.handleHandshakeMessage(s2, (ByteArrayInputStream)object);
        }
    }

    private void b() {
    }

    private void c() throws IOException {
        while (this.c.available() >= 2) {
            byte[] byArray = this.c.removeData(2, 0);
            short s2 = byArray[0];
            short s3 = byArray[1];
            this.handleAlertMessage(s2, s3);
        }
    }

    private void a(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            short s2 = TlsUtils.readUint8(byArray, n2 + i2);
            if (s2 != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.c.available() > 0 || this.d.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.b.d();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    protected int applicationDataAvailable() {
        return this.a.available();
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        while (this.a.available() == 0) {
            if (this.g) {
                if (this.h) {
                    throw new IOException("Cannot read application data on failed TLS connection");
                }
                if (!this.i) {
                    throw new IllegalStateException("Cannot read application data until initial handshake completed.");
                }
                return -1;
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.a.available());
        this.a.removeData(buf, offset, len, 0);
        return len;
    }

    protected void safeCheckRecordHeader(byte[] recordHeader) throws IOException {
        try {
            this.b.a(recordHeader);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (this.b.f()) {
                return;
            }
            if (!this.i) {
                throw new TlsFatalAlert(40);
            }
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to read record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to read record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to read record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        this.handleFailure();
        throw new TlsNoCloseNotifyException();
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.b.a(type, buf, offset, len);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.handleException(tlsFatalAlert.getAlertDescription(), "Failed to write record", tlsFatalAlert);
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.handleException((short)80, "Failed to write record", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.handleException((short)80, "Failed to write record", runtimeException);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        if (this.g) {
            throw new IOException("Cannot write application data on closed/failed TLS connection");
        }
        while (len > 0) {
            if (this.j) {
                switch (this.k) {
                    case 2: {
                        this.j = false;
                    }
                    case 1: {
                        this.safeWriteRecord((short)23, TlsUtils.EMPTY_BYTES, 0, 0);
                        break;
                    }
                    default: {
                        this.safeWriteRecord((short)23, buf, offset, 1);
                        ++offset;
                        --len;
                    }
                }
            }
            if (len <= 0) continue;
            int n2 = Math.min(len, this.b.a());
            this.safeWriteRecord((short)23, buf, offset, n2);
            offset += n2;
            len -= n2;
        }
    }

    protected void setAppDataSplitMode(int appDataSplitMode) {
        if (appDataSplitMode < 0 || appDataSplitMode > 2) {
            throw new IllegalArgumentException("Illegal appDataSplitMode mode: " + appDataSplitMode);
        }
        this.k = appDataSplitMode;
    }

    protected void writeHandshakeMessage(byte[] buf, int off, int len) throws IOException {
        int n2;
        if (len < 4) {
            throw new TlsFatalAlert(80);
        }
        short s2 = TlsUtils.readUint8(buf, off);
        if (s2 != 0) {
            this.b.i().write(buf, off, len);
        }
        int n3 = 0;
        do {
            n2 = Math.min(len - n3, this.b.a());
            this.safeWriteRecord((short)22, buf, off + n3, n2);
        } while ((n3 += n2) < len);
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.f;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.e;
    }

    public void closeInput() throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use closeInput() in blocking mode!");
        }
        if (this.g) {
            return;
        }
        if (this.inputBuffers.available() > 0) {
            throw new EOFException();
        }
        if (!this.i) {
            throw new TlsFatalAlert(40);
        }
        throw new TlsNoCloseNotifyException();
    }

    public void offerInput(byte[] input) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.g) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        this.inputBuffers.addBytes(input);
        while (this.inputBuffers.available() >= 5) {
            byte[] byArray = new byte[5];
            this.inputBuffers.peek(byArray);
            int n2 = TlsUtils.readUint16(byArray, 3) + 5;
            if (this.inputBuffers.available() < n2) {
                this.safeCheckRecordHeader(byArray);
                break;
            }
            this.safeReadRecord();
            if (!this.g) continue;
            if (this.connection_state == 16) break;
            throw new TlsFatalAlert(80);
        }
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        try {
            return this.readApplicationData(buffer, offset, Math.min(length, this.applicationDataAvailable()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void offerOutput(byte[] buffer, int offset, int length) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerOutput() in blocking mode! Use getOutputStream() instead.");
        }
        if (!this.i) {
            throw new IOException("Application data cannot be sent until the handshake is complete!");
        }
        this.writeData(buffer, offset, length);
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int n2 = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, offset, n2, 0);
        return n2;
    }

    protected void invalidateSession() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
            this.tlsSession = null;
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        if (this.l == null) {
            throw new TlsFatalAlert(80);
        }
        byte[] byArray = TlsUtils.readFully(this.l.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual(this.l, byArray)) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void raiseAlertFatal(short alertDescription, String message, Throwable cause) throws IOException {
        this.getPeer().notifyAlertRaised((short)2, alertDescription, message, cause);
        byte[] byArray = new byte[]{2, (byte)alertDescription};
        try {
            this.b.a((short)21, byArray, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void raiseAlertWarning(short alertDescription, String message) throws IOException {
        this.getPeer().notifyAlertRaised((short)1, alertDescription, message, null);
        byte[] byArray = new byte[]{1, (byte)alertDescription};
        this.safeWriteRecord((short)21, byArray, 0, 2);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        ProtocolVersion protocolVersion;
        Object object;
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.isEmpty() && !(object = this.getContext()).isServer() && (protocolVersion = this.getContext().getServerVersion()).isSSL()) {
            String string = protocolVersion.toString() + " client didn't provide credentials";
            this.raiseAlertWarning((short)41, string);
            return;
        }
        object = new a(11);
        certificate.encode((OutputStream)object);
        ((a)object).a();
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] byArray = new byte[]{1};
        this.safeWriteRecord((short)20, byArray, 0, byArray.length);
        this.b.c();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] byArray = this.createVerifyData(this.getContext().isServer());
        a a2 = new a(20, byArray.length);
        a2.write(byArray);
        a2.a();
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        a a2 = new a(23);
        TlsProtocol.writeSupplementalData(a2, supplementalData);
        a2.a();
    }

    protected byte[] createVerifyData(boolean isServer) {
        TlsContext tlsContext = this.getContext();
        String string = isServer ? "server finished" : "client finished";
        byte[] byArray = isServer ? TlsUtils.b : TlsUtils.a;
        byte[] byArray2 = TlsProtocol.getCurrentPRFHash(tlsContext, this.b.h(), byArray);
        return TlsUtils.a(tlsContext, string, byArray2);
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    protected void flush() throws IOException {
        this.b.l();
    }

    public boolean isClosed() {
        return this.g;
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short s2 = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (s2 >= 0 && (!MaxFragmentLength.isValid(s2) || !this.resumedSession && s2 != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return s2;
    }

    protected void refuseRenegotiation() throws IOException {
        if (TlsUtils.isSSL(this.getContext())) {
            throw new TlsFatalAlert(40);
        }
        this.raiseAlertWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean useGMTUnixTime, RandomGenerator randomGenerator) {
        byte[] byArray = new byte[32];
        randomGenerator.nextBytes(byArray);
        if (useGMTUnixTime) {
            TlsUtils.writeGMTUnixTime(byArray, 0);
        }
        return byArray;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        byte[] byArray = keyExchange.generatePremasterSecret();
        try {
            context.getSecurityParameters().f = TlsUtils.a(context, byArray);
        }
        finally {
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    protected static byte[] getCurrentPRFHash(TlsContext context, TlsHandshakeHash handshakeHash, byte[] sslSender) {
        Digest digest = handshakeHash.forkPRFHash();
        if (sslSender != null && TlsUtils.isSSL(context)) {
            digest.update(sslSender, 0, sslSender.length);
        }
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] byArray = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Hashtable<Integer, byte[]> hashtable = new Hashtable<Integer, byte[]>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2;
            Integer n2 = Integers.valueOf(TlsUtils.readUint16(byteArrayInputStream));
            if (null == hashtable.put(n2, byArray2 = TlsUtils.readOpaque16(byteArrayInputStream))) continue;
            throw new TlsFatalAlert(47);
        }
        return hashtable;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque24(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<SupplementalDataEntry> vector = new Vector<SupplementalDataEntry>();
        while (byteArrayInputStream.available() > 0) {
            int n2 = TlsUtils.readUint16(byteArrayInputStream);
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            vector.addElement(new SupplementalDataEntry(n2, byArray2));
        }
        return vector;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, extensions, true);
        TlsProtocol.writeSelectedExtensions(byteArrayOutputStream, extensions, false);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque16(byArray, output);
    }

    protected static void writeSelectedExtensions(OutputStream output, Hashtable extensions, boolean selectEmpty) throws IOException {
        Enumeration enumeration = extensions.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            int n3 = n2;
            byte[] byArray = (byte[])extensions.get(n2);
            if (selectEmpty != (byArray.length == 0)) continue;
            TlsUtils.checkUint16(n3);
            TlsUtils.writeUint16(n3, output);
            TlsUtils.writeOpaque16(byArray, output);
        }
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < supplementalData.size(); ++i2) {
            SupplementalDataEntry supplementalDataEntry = (SupplementalDataEntry)supplementalData.elementAt(i2);
            int n2 = supplementalDataEntry.getDataType();
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
            TlsUtils.writeOpaque16(supplementalDataEntry.getData(), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque24(byArray, output);
    }

    protected static int getPRFAlgorithm(TlsContext context, int ciphersuite) throws IOException {
        boolean bl = TlsUtils.isTLSv12(context);
        switch (ciphersuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                if (bl) {
                    return 1;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                if (bl) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (bl) {
                    return 2;
                }
                return 0;
            }
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    class a
    extends ByteArrayOutputStream {
        a(short s2) throws IOException {
            this(s2, 60);
        }

        a(short s2, int n2) throws IOException {
            super(n2 + 4);
            TlsUtils.writeUint8(s2, (OutputStream)this);
            this.count += 3;
        }

        void a() throws IOException {
            int n2 = this.count - 4;
            TlsUtils.checkUint24(n2);
            TlsUtils.writeUint24(n2, this.buf, 1);
            TlsProtocol.this.writeHandshakeMessage(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

