/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.enterprisedt.bouncycastle.crypto.engines.RSABlindedEngine;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext context, RSAKeyParameters rsaServerPublicKey, OutputStream output) throws IOException {
        byte[] byArray = new byte[48];
        context.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(context.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rsaServerPublicKey, context.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (TlsUtils.isSSL(context)) {
                output.write(byArray2);
            } else {
                TlsUtils.writeOpaque16(byArray2, output);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
        }
        return byArray;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext context, RSAKeyParameters rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        ProtocolVersion protocolVersion = context.getClientVersion();
        boolean bl = false;
        byte[] byArray = new byte[48];
        context.getSecureRandom().nextBytes(byArray);
        byte[] byArray2 = Arrays.clone(byArray);
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), byArray);
            pKCS1Encoding.init(false, new ParametersWithRandom(rsaServerPrivateKey, context.getSecureRandom()));
            byArray2 = pKCS1Encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || !protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int n2 = protocolVersion.getMajorVersion() ^ byArray2[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray2[1] & 0xFF;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            int n3 = ~((n2 & 1) - 1);
            for (int i2 = 0; i2 < 48; ++i2) {
                byArray2[i2] = (byte)(byArray2[i2] & ~n3 | byArray[i2] & n3);
            }
        }
        return byArray2;
    }
}

