/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.tls;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.tls.TlsCipher;
import com.enterprisedt.bouncycastle.crypto.tls.TlsContext;
import com.enterprisedt.bouncycastle.crypto.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.crypto.tls.TlsMac;
import com.enterprisedt.bouncycastle.crypto.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsContext context, StreamCipher clientWriteCipher, StreamCipher serverWriteCipher, Digest clientWriteDigest, Digest serverWriteDigest, int cipherKeySize, boolean usesNonce) throws IOException {
        CipherParameters cipherParameters;
        CipherParameters cipherParameters2;
        boolean bl = context.isServer();
        this.context = context;
        this.usesNonce = usesNonce;
        this.encryptCipher = clientWriteCipher;
        this.decryptCipher = serverWriteCipher;
        int n2 = 2 * cipherKeySize + clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
        byte[] byArray = TlsUtils.a(context, n2);
        int n3 = 0;
        TlsMac tlsMac = new TlsMac(context, clientWriteDigest, byArray, n3, clientWriteDigest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(context, serverWriteDigest, byArray, n3 += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray, n3 += serverWriteDigest.getDigestSize(), cipherKeySize);
        KeyParameter keyParameter2 = new KeyParameter(byArray, n3 += cipherKeySize, cipherKeySize);
        if ((n3 += cipherKeySize) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (bl) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            cipherParameters2 = keyParameter2;
            cipherParameters = keyParameter;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            cipherParameters2 = keyParameter;
            cipherParameters = keyParameter2;
        }
        if (usesNonce) {
            byte[] byArray2 = new byte[8];
            cipherParameters2 = new ParametersWithIV(cipherParameters2, byArray2);
            cipherParameters = new ParametersWithIV(cipherParameters, byArray2);
        }
        this.encryptCipher.init(true, cipherParameters2);
        this.decryptCipher.init(false, cipherParameters);
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, seqNo);
        }
        byte[] byArray = new byte[len + this.writeMac.getSize()];
        this.encryptCipher.processBytes(plaintext, offset, len, byArray, 0);
        byte[] byArray2 = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        this.encryptCipher.processBytes(byArray2, 0, byArray2.length, byArray, len);
        return byArray;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, seqNo);
        }
        if (len < (n2 = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int n3 = len - n2;
        byte[] byArray = new byte[len];
        this.decryptCipher.processBytes(ciphertext, offset, len, byArray, 0);
        this.checkMAC(seqNo, type, byArray, n3, len, byArray, 0, n3);
        return Arrays.copyOfRange(byArray, 0, n3);
    }

    protected void checkMAC(long seqNo, short type, byte[] recBuf, int recStart, int recEnd, byte[] calcBuf, int calcOff, int calcLen) throws IOException {
        byte[] byArray;
        byte[] byArray2 = Arrays.copyOfRange(recBuf, recStart, recEnd);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray = this.readMac.calculateMac(seqNo, type, calcBuf, calcOff, calcLen))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(StreamCipher cipher, boolean forEncryption, long seqNo) {
        byte[] byArray = new byte[8];
        TlsUtils.writeUint64(seqNo, byArray, 0);
        cipher.init(forEncryption, new ParametersWithIV(null, byArray));
    }
}

