/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.GLVMultiplier;
import com.enterprisedt.bouncycastle.math.ec.PreCompCallback;
import com.enterprisedt.bouncycastle.math.ec.PreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WNafL2RMultiplier;
import com.enterprisedt.bouncycastle.math.ec.WTauNafMultiplier;
import com.enterprisedt.bouncycastle.math.ec.a;
import com.enterprisedt.bouncycastle.math.ec.c;
import com.enterprisedt.bouncycastle.math.ec.endo.ECEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.enterprisedt.bouncycastle.math.field.FiniteField;
import com.enterprisedt.bouncycastle.math.field.FiniteFields;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Random;

public abstract class ECCurve {
    public static final int COORD_AFFINE = 0;
    public static final int COORD_HOMOGENEOUS = 1;
    public static final int COORD_JACOBIAN = 2;
    public static final int COORD_JACOBIAN_CHUDNOVSKY = 3;
    public static final int COORD_JACOBIAN_MODIFIED = 4;
    public static final int COORD_LAMBDA_AFFINE = 5;
    public static final int COORD_LAMBDA_PROJECTIVE = 6;
    public static final int COORD_SKEWED = 7;
    protected FiniteField field;
    protected ECFieldElement a;
    protected ECFieldElement b;
    protected BigInteger order;
    protected BigInteger cofactor;
    protected int coord = 0;
    protected ECEndomorphism endomorphism = null;
    protected ECMultiplier multiplier = null;

    public static int[] getAllCoordinateSystems() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    protected ECCurve(FiniteField field) {
        this.field = field;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract boolean isValidFieldElement(BigInteger var1);

    public synchronized Config configure() {
        return new Config(this.coord, this.endomorphism, this.multiplier);
    }

    public ECPoint validatePoint(BigInteger x2, BigInteger y2) {
        ECPoint eCPoint = this.createPoint(x2, y2);
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point coordinates");
        }
        return eCPoint;
    }

    public ECPoint validatePoint(BigInteger x2, BigInteger y2, boolean withCompression) {
        ECPoint eCPoint = this.createPoint(x2, y2, withCompression);
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Invalid point coordinates");
        }
        return eCPoint;
    }

    public ECPoint createPoint(BigInteger x2, BigInteger y2) {
        return this.createPoint(x2, y2, false);
    }

    public ECPoint createPoint(BigInteger x2, BigInteger y2, boolean withCompression) {
        return this.createRawPoint(this.fromBigInteger(x2), this.fromBigInteger(y2), withCompression);
    }

    protected abstract ECCurve cloneCurve();

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, boolean var3);

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2, ECFieldElement[] var3, boolean var4);

    protected ECMultiplier createDefaultMultiplier() {
        if (this.endomorphism instanceof GLVEndomorphism) {
            return new GLVMultiplier(this, (GLVEndomorphism)this.endomorphism);
        }
        return new WNafL2RMultiplier();
    }

    public boolean supportsCoordinateSystem(int coord) {
        return coord == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo getPreCompInfo(ECPoint point, String name) {
        Hashtable hashtable;
        this.checkPoint(point);
        Object object = point;
        synchronized (object) {
            hashtable = point.preCompTable;
        }
        if (null == hashtable) {
            return null;
        }
        object = hashtable;
        synchronized (object) {
            return (PreCompInfo)hashtable.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreCompInfo precompute(ECPoint point, String name, PreCompCallback callback) {
        Hashtable<String, PreCompInfo> hashtable;
        this.checkPoint(point);
        Object object = point;
        synchronized (object) {
            hashtable = point.preCompTable;
            if (null == hashtable) {
                point.preCompTable = hashtable = new Hashtable<String, PreCompInfo>(4);
            }
        }
        object = hashtable;
        synchronized (object) {
            PreCompInfo preCompInfo = (PreCompInfo)hashtable.get(name);
            PreCompInfo preCompInfo2 = callback.precompute(preCompInfo);
            if (preCompInfo2 != preCompInfo) {
                hashtable.put(name, preCompInfo2);
            }
            return preCompInfo2;
        }
    }

    public ECPoint importPoint(ECPoint p2) {
        if (this == p2.getCurve()) {
            return p2;
        }
        if (p2.isInfinity()) {
            return this.getInfinity();
        }
        p2 = p2.normalize();
        return this.createPoint(p2.getXCoord().toBigInteger(), p2.getYCoord().toBigInteger(), p2.withCompression);
    }

    public void normalizeAll(ECPoint[] points) {
        this.normalizeAll(points, 0, points.length, null);
    }

    public void normalizeAll(ECPoint[] points, int off, int len, ECFieldElement iso) {
        int n2;
        this.checkPoints(points, off, len);
        switch (this.getCoordinateSystem()) {
            case 0: 
            case 5: {
                if (iso != null) {
                    throw new IllegalArgumentException("'iso' not valid for affine coordinates");
                }
                return;
            }
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[len];
        int[] nArray = new int[len];
        int n3 = 0;
        for (n2 = 0; n2 < len; ++n2) {
            ECPoint eCPoint = points[off + n2];
            if (null == eCPoint || iso == null && eCPoint.isNormalized()) continue;
            eCFieldElementArray[n3] = eCPoint.getZCoord(0);
            nArray[n3++] = off + n2;
        }
        if (n3 == 0) {
            return;
        }
        ECAlgorithms.montgomeryTrick(eCFieldElementArray, 0, n3, iso);
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = nArray[n2];
            points[n4] = points[n4].a(eCFieldElementArray[n2]);
        }
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public BigInteger getCofactor() {
        return this.cofactor;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECEndomorphism getEndomorphism() {
        return this.endomorphism;
    }

    public synchronized ECMultiplier getMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = this.createDefaultMultiplier();
        }
        return this.multiplier;
    }

    public ECPoint decodePoint(byte[] encoded) {
        ECPoint eCPoint = null;
        int n2 = (this.getFieldSize() + 7) / 8;
        byte by = encoded[0];
        switch (by) {
            case 0: {
                if (encoded.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                eCPoint = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (encoded.length != n2 + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int n3 = by & 1;
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(encoded, 1, n2);
                eCPoint = this.decompressPoint(n3, bigInteger);
                if (eCPoint.isValid()) break;
                throw new IllegalArgumentException("Invalid point");
            }
            case 4: {
                if (encoded.length != 2 * n2 + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(encoded, 1, n2);
                BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray(encoded, 1 + n2, n2);
                eCPoint = this.validatePoint(bigInteger, bigInteger2);
                break;
            }
            case 6: 
            case 7: {
                if (encoded.length != 2 * n2 + 1) {
                    throw new IllegalArgumentException("Incorrect length for hybrid encoding");
                }
                BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(encoded, 1, n2);
                BigInteger bigInteger3 = BigIntegers.fromUnsignedByteArray(encoded, 1 + n2, n2);
                if (bigInteger3.testBit(0) != (by == 7)) {
                    throw new IllegalArgumentException("Inconsistent Y coordinate in hybrid encoding");
                }
                eCPoint = this.validatePoint(bigInteger, bigInteger3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(by, 16));
            }
        }
        if (by != 0 && eCPoint.isInfinity()) {
            throw new IllegalArgumentException("Invalid infinity encoding");
        }
        return eCPoint;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        final int n2 = this.getFieldSize() + 7 >>> 3;
        final byte[] byArray = new byte[len * n2 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            byte[] byArray2 = eCPoint.getRawXCoord().toBigInteger().toByteArray();
            byte[] byArray3 = eCPoint.getRawYCoord().toBigInteger().toByteArray();
            int n4 = byArray2.length > n2 ? 1 : 0;
            int n5 = byArray2.length - n4;
            int n6 = byArray3.length > n2 ? 1 : 0;
            int n7 = byArray3.length - n6;
            System.arraycopy(byArray2, n4, byArray, n3 + n2 - n5, n5);
            System.arraycopy(byArray3, n6, byArray, (n3 += n2) + n2 - n7, n7);
            n3 += n2;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                byte[] byArray3 = new byte[n2];
                byte[] byArray2 = new byte[n2];
                int n22 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int n4 = i3;
                        byArray3[n4] = (byte)(byArray3[n4] ^ byArray[n22 + i3] & n3);
                        int n5 = i3;
                        byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n22 + n2 + i3] & n3);
                    }
                    n22 += n2 * 2;
                }
                return ECCurve.this.createRawPoint(ECCurve.this.fromBigInteger(new BigInteger(1, byArray3)), ECCurve.this.fromBigInteger(new BigInteger(1, byArray2)), false);
            }
        };
    }

    protected void checkPoint(ECPoint point) {
        if (null == point || this != point.getCurve()) {
            throw new IllegalArgumentException("'point' must be non-null and on this curve");
        }
    }

    protected void checkPoints(ECPoint[] points) {
        this.checkPoints(points, 0, points.length);
    }

    protected void checkPoints(ECPoint[] points, int off, int len) {
        if (points == null) {
            throw new IllegalArgumentException("'points' cannot be null");
        }
        if (off < 0 || len < 0 || off > points.length - len) {
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            if (null == eCPoint || this == eCPoint.getCurve()) continue;
            throw new IllegalArgumentException("'points' entries must be null or on this curve");
        }
    }

    public boolean equals(ECCurve other) {
        return this == other || null != other && this.getField().equals(other.getField()) && this.getA().toBigInteger().equals(other.getA().toBigInteger()) && this.getB().toBigInteger().equals(other.getB().toBigInteger());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ECCurve && this.equals((ECCurve)obj);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft(this.getA().toBigInteger().hashCode(), 8) ^ Integers.rotateLeft(this.getB().toBigInteger().hashCode(), 16);
    }

    public static class F2m
    extends AbstractF2m {
        private int c;
        private int d;
        private int e;
        private int f;
        private ECPoint.F2m g;

        public F2m(int m2, int k2, BigInteger a2, BigInteger b2) {
            this(m2, k2, 0, 0, a2, b2, null, null);
        }

        public F2m(int m2, int k2, BigInteger a2, BigInteger b2, BigInteger order, BigInteger cofactor) {
            this(m2, k2, 0, 0, a2, b2, order, cofactor);
        }

        public F2m(int m2, int k1, int k2, int k3, BigInteger a2, BigInteger b2) {
            this(m2, k1, k2, k3, a2, b2, null, null);
        }

        public F2m(int m2, int k1, int k2, int k3, BigInteger a2, BigInteger b2, BigInteger order, BigInteger cofactor) {
            super(m2, k1, k2, k3);
            this.c = m2;
            this.d = k1;
            this.e = k2;
            this.f = k3;
            this.order = order;
            this.cofactor = cofactor;
            this.g = new ECPoint.F2m((ECCurve)this, null, null, false);
            this.a = this.fromBigInteger(a2);
            this.b = this.fromBigInteger(b2);
            this.coord = 6;
        }

        protected F2m(int m2, int k1, int k2, int k3, ECFieldElement a2, ECFieldElement b2, BigInteger order, BigInteger cofactor) {
            super(m2, k1, k2, k3);
            this.c = m2;
            this.d = k1;
            this.e = k2;
            this.f = k3;
            this.order = order;
            this.cofactor = cofactor;
            this.g = new ECPoint.F2m((ECCurve)this, null, null, false);
            this.a = a2;
            this.b = b2;
            this.coord = 6;
        }

        @Override
        protected ECCurve cloneCurve() {
            return new F2m(this.c, this.d, this.e, this.f, this.a, this.b, this.order, this.cofactor);
        }

        @Override
        public boolean supportsCoordinateSystem(int coord) {
            switch (coord) {
                case 0: 
                case 1: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected ECMultiplier createDefaultMultiplier() {
            if (this.isKoblitz()) {
                return new WTauNafMultiplier();
            }
            return super.createDefaultMultiplier();
        }

        @Override
        public int getFieldSize() {
            return this.c;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger x2) {
            return new ECFieldElement.F2m(this.c, this.d, this.e, this.f, x2);
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
            return new ECPoint.F2m((ECCurve)this, x2, y2, withCompression);
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
            return new ECPoint.F2m(this, x2, y2, zs, withCompression);
        }

        @Override
        public ECPoint getInfinity() {
            return this.g;
        }

        public int getM() {
            return this.c;
        }

        public boolean isTrinomial() {
            return this.e == 0 && this.f == 0;
        }

        public int getK1() {
            return this.d;
        }

        public int getK2() {
            return this.e;
        }

        public int getK3() {
            return this.f;
        }

        @Override
        public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
            int[] nArray;
            final int n2 = this.c + 63 >>> 6;
            if (this.isTrinomial()) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.d;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = this.d;
                nArray3[1] = this.e;
                nArray = nArray3;
                nArray3[2] = this.f;
            }
            final int[] nArray4 = nArray;
            final long[] lArray = new long[len * n2 * 2];
            int n3 = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                ECPoint eCPoint = points[off + i2];
                ((ECFieldElement.F2m)eCPoint.getRawXCoord()).a.a(lArray, n3);
                ((ECFieldElement.F2m)eCPoint.getRawYCoord()).a.a(lArray, n3 += n2);
                n3 += n2;
            }
            return new ECLookupTable(){

                @Override
                public int getSize() {
                    return len;
                }

                @Override
                public ECPoint lookup(int index) {
                    long[] lArray3 = Nat.create64(n2);
                    long[] lArray2 = Nat.create64(n2);
                    int n22 = 0;
                    for (int i2 = 0; i2 < len; ++i2) {
                        long l2 = (i2 ^ index) - 1 >> 31;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            int n3 = i3;
                            lArray3[n3] = lArray3[n3] ^ lArray[n22 + i3] & l2;
                            int n4 = i3;
                            lArray2[n4] = lArray2[n4] ^ lArray[n22 + n2 + i3] & l2;
                        }
                        n22 += n2 * 2;
                    }
                    return F2m.this.createRawPoint(new ECFieldElement.F2m(F2m.this.c, nArray4, new a(lArray3)), new ECFieldElement.F2m(F2m.this.c, nArray4, new a(lArray2)), false);
                }
            };
        }
    }

    public static abstract class AbstractF2m
    extends ECCurve {
        private BigInteger[] c = null;

        public static BigInteger inverse(int m2, int[] ks, BigInteger x2) {
            return new a(x2).d(m2, ks).e();
        }

        private static FiniteField a(int n2, int n3, int n4, int n5) {
            if (n3 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (n4 == 0) {
                if (n5 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
                return FiniteFields.getBinaryExtensionField(new int[]{0, n3, n2});
            }
            if (n4 <= n3) {
                throw new IllegalArgumentException("k2 must be > k1");
            }
            if (n5 <= n4) {
                throw new IllegalArgumentException("k3 must be > k2");
            }
            return FiniteFields.getBinaryExtensionField(new int[]{0, n3, n4, n5, n2});
        }

        protected AbstractF2m(int m2, int k1, int k2, int k3) {
            super(AbstractF2m.a(m2, k1, k2, k3));
        }

        @Override
        public boolean isValidFieldElement(BigInteger x2) {
            return x2 != null && x2.signum() >= 0 && x2.bitLength() <= this.getFieldSize();
        }

        @Override
        public ECPoint createPoint(BigInteger x2, BigInteger y2, boolean withCompression) {
            ECFieldElement eCFieldElement = this.fromBigInteger(x2);
            ECFieldElement eCFieldElement2 = this.fromBigInteger(y2);
            int n2 = this.getCoordinateSystem();
            switch (n2) {
                case 5: 
                case 6: {
                    if (eCFieldElement.isZero()) {
                        if (eCFieldElement2.square().equals(this.getB())) break;
                        throw new IllegalArgumentException();
                    }
                    eCFieldElement2 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                    break;
                }
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2, withCompression);
        }

        @Override
        protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
            ECFieldElement eCFieldElement = this.fromBigInteger(X1);
            ECFieldElement eCFieldElement2 = null;
            if (eCFieldElement.isZero()) {
                eCFieldElement2 = this.getB().sqrt();
            } else {
                ECFieldElement eCFieldElement3 = eCFieldElement.square().invert().multiply(this.getB()).add(this.getA()).add(eCFieldElement);
                ECFieldElement eCFieldElement4 = this.solveQuadraticEquation(eCFieldElement3);
                if (eCFieldElement4 != null) {
                    if (eCFieldElement4.testBitZero() != (yTilde == 1)) {
                        eCFieldElement4 = eCFieldElement4.addOne();
                    }
                    switch (this.getCoordinateSystem()) {
                        case 5: 
                        case 6: {
                            eCFieldElement2 = eCFieldElement4.add(eCFieldElement);
                            break;
                        }
                        default: {
                            eCFieldElement2 = eCFieldElement4.multiply(eCFieldElement);
                        }
                    }
                }
            }
            if (eCFieldElement2 == null) {
                throw new IllegalArgumentException("Invalid point compression");
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2, true);
        }

        protected ECFieldElement solveQuadraticEquation(ECFieldElement beta) {
            ECFieldElement eCFieldElement;
            ECFieldElement eCFieldElement2;
            if (beta.isZero()) {
                return beta;
            }
            ECFieldElement eCFieldElement3 = this.fromBigInteger(ECConstants.ZERO);
            int n2 = this.getFieldSize();
            Random random = new Random();
            do {
                ECFieldElement eCFieldElement4 = this.fromBigInteger(new BigInteger(n2, random));
                eCFieldElement = eCFieldElement3;
                ECFieldElement eCFieldElement5 = beta;
                for (int i2 = 1; i2 < n2; ++i2) {
                    ECFieldElement eCFieldElement6 = eCFieldElement5.square();
                    eCFieldElement = eCFieldElement.square().add(eCFieldElement6.multiply(eCFieldElement4));
                    eCFieldElement5 = eCFieldElement6.add(beta);
                }
                if (eCFieldElement5.isZero()) continue;
                return null;
            } while ((eCFieldElement2 = eCFieldElement.square().add(eCFieldElement)).isZero());
            return eCFieldElement;
        }

        synchronized BigInteger[] a() {
            if (this.c == null) {
                this.c = com.enterprisedt.bouncycastle.math.ec.c.a(this);
            }
            return this.c;
        }

        public boolean isKoblitz() {
            return this.order != null && this.cofactor != null && this.b.isOne() && (this.a.isZero() || this.a.isOne());
        }
    }

    public static class Fp
    extends AbstractFp {
        BigInteger c;
        BigInteger d;
        ECPoint.Fp e;

        public Fp(BigInteger q2, BigInteger a2, BigInteger b2) {
            this(q2, a2, b2, null, null);
        }

        public Fp(BigInteger q2, BigInteger a2, BigInteger b2, BigInteger order, BigInteger cofactor) {
            super(q2);
            this.c = q2;
            this.d = ECFieldElement.Fp.a(q2);
            this.e = new ECPoint.Fp((ECCurve)this, null, null, false);
            this.a = this.fromBigInteger(a2);
            this.b = this.fromBigInteger(b2);
            this.order = order;
            this.cofactor = cofactor;
            this.coord = 4;
        }

        protected Fp(BigInteger q2, BigInteger r2, ECFieldElement a2, ECFieldElement b2) {
            this(q2, r2, a2, b2, null, null);
        }

        protected Fp(BigInteger q2, BigInteger r2, ECFieldElement a2, ECFieldElement b2, BigInteger order, BigInteger cofactor) {
            super(q2);
            this.c = q2;
            this.d = r2;
            this.e = new ECPoint.Fp((ECCurve)this, null, null, false);
            this.a = a2;
            this.b = b2;
            this.order = order;
            this.cofactor = cofactor;
            this.coord = 4;
        }

        @Override
        protected ECCurve cloneCurve() {
            return new Fp(this.c, this.d, this.a, this.b, this.order, this.cofactor);
        }

        @Override
        public boolean supportsCoordinateSystem(int coord) {
            switch (coord) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public BigInteger getQ() {
            return this.c;
        }

        @Override
        public int getFieldSize() {
            return this.c.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger x2) {
            return new ECFieldElement.Fp(this.c, this.d, x2);
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
            return new ECPoint.Fp((ECCurve)this, x2, y2, withCompression);
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement x2, ECFieldElement y2, ECFieldElement[] zs, boolean withCompression) {
            return new ECPoint.Fp(this, x2, y2, zs, withCompression);
        }

        @Override
        public ECPoint importPoint(ECPoint p2) {
            if (this != p2.getCurve() && this.getCoordinateSystem() == 2 && !p2.isInfinity()) {
                switch (p2.getCurve().getCoordinateSystem()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return new ECPoint.Fp(this, this.fromBigInteger(p2.x.toBigInteger()), this.fromBigInteger(p2.y.toBigInteger()), new ECFieldElement[]{this.fromBigInteger(p2.zs[0].toBigInteger())}, p2.withCompression);
                    }
                }
            }
            return super.importPoint(p2);
        }

        @Override
        public ECPoint getInfinity() {
            return this.e;
        }
    }

    public static abstract class AbstractFp
    extends ECCurve {
        protected AbstractFp(BigInteger q2) {
            super(FiniteFields.getPrimeField(q2));
        }

        @Override
        public boolean isValidFieldElement(BigInteger x2) {
            return x2 != null && x2.signum() >= 0 && x2.compareTo(this.getField().getCharacteristic()) < 0;
        }

        @Override
        protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
            ECFieldElement eCFieldElement = this.fromBigInteger(X1);
            ECFieldElement eCFieldElement2 = eCFieldElement.square().add(this.a).multiply(eCFieldElement).add(this.b);
            ECFieldElement eCFieldElement3 = eCFieldElement2.sqrt();
            if (eCFieldElement3 == null) {
                throw new IllegalArgumentException("Invalid point compression");
            }
            if (eCFieldElement3.testBitZero() != (yTilde == 1)) {
                eCFieldElement3 = eCFieldElement3.negate();
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement3, true);
        }
    }

    public class Config {
        protected int coord;
        protected ECEndomorphism endomorphism;
        protected ECMultiplier multiplier;

        Config(int coord, ECEndomorphism endomorphism, ECMultiplier multiplier) {
            this.coord = coord;
            this.endomorphism = endomorphism;
            this.multiplier = multiplier;
        }

        public Config setCoordinateSystem(int coord) {
            this.coord = coord;
            return this;
        }

        public Config setEndomorphism(ECEndomorphism endomorphism) {
            this.endomorphism = endomorphism;
            return this;
        }

        public Config setMultiplier(ECMultiplier multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ECCurve create() {
            if (!ECCurve.this.supportsCoordinateSystem(this.coord)) {
                throw new IllegalStateException("unsupported coordinate system");
            }
            ECCurve eCCurve = ECCurve.this.cloneCurve();
            if (eCCurve == ECCurve.this) {
                throw new IllegalStateException("implementation returned current curve");
            }
            ECCurve eCCurve2 = eCCurve;
            synchronized (eCCurve2) {
                eCCurve.coord = this.coord;
                eCCurve.endomorphism = this.endomorphism;
                eCCurve.multiplier = this.multiplier;
            }
            return eCCurve;
        }
    }
}

